/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLPipeline {
    private InputStream inputStream;
    private ByteArrayOutputStream outputStream;
    private List<Transformer> transformers = new ArrayList<Transformer>();
    private boolean omitXMLDeclaration;

    public XSLPipeline(InputStream inputStream, boolean omitXMLDeclaration) {
        this.inputStream = inputStream;
        this.omitXMLDeclaration = omitXMLDeclaration;
    }

    public XSLPipeline apply(Transformer xslTransformer) {
        this.transformers.add(xslTransformer);
        return this;
    }

    public InputStream process() throws TransformerException {
        for (Transformer transformer : this.transformers) {
            this.outputStream = new ByteArrayOutputStream();
            transformer.setOutputProperty("omit-xml-declaration", this.omitXMLDeclaration ? "yes" : "no");
            transformer.transform(new StreamSource(this.inputStream), new StreamResult(this.outputStream));
            this.inputStream = new ByteArrayInputStream(this.outputStream.toByteArray());
        }
        return this.inputStream;
    }
}

