/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.xml;

import com.lyncode.xml.exceptions.XmlWriteException;
import java.io.ByteArrayInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLInputFactory2;
import org.dspace.xoai.xml.XmlWritable;
import org.dspace.xoai.xml.XmlWriter;

public class EchoElement
implements XmlWritable {
    private static XMLInputFactory factory = XMLInputFactory2.newFactory();
    private String xmlString = null;
    private Stack<Set<String>> declaredPrefixes = new Stack();

    public EchoElement(String xmlString) {
        this.xmlString = xmlString;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            XMLEventReader reader = factory.createXMLEventReader(new ByteArrayInputStream(this.xmlString.getBytes()));
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    this.declaredPrefixes.push(new HashSet());
                    QName name = event.asStartElement().getName();
                    writer.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
                    this.addNamespaceIfRequired(writer, name);
                    Iterator itNamespaces = event.asStartElement().getNamespaces();
                    while (itNamespaces.hasNext()) {
                        Namespace namespace = (Namespace)itNamespaces.next();
                        this.addNamespaceIfRequired(writer, new QName(namespace.getNamespaceURI(), "", namespace.getPrefix()));
                    }
                    Iterator it = event.asStartElement().getAttributes();
                    while (it.hasNext()) {
                        Attribute attr = (Attribute)it.next();
                        QName attrName = attr.getName();
                        this.addNamespaceIfRequired(writer, attrName);
                        writer.writeAttribute(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalPart(), attr.getValue());
                    }
                    continue;
                }
                if (event.isEndElement()) {
                    this.declaredPrefixes.pop();
                    writer.writeEndElement();
                    continue;
                }
                if (!event.isCharacters()) continue;
                writer.writeCharacters(event.asCharacters().getData());
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException("Error trying to output '" + this.xmlString + "'", e);
        }
    }

    private void addNamespaceIfRequired(XmlWriter writer, QName name) throws XMLStreamException {
        for (Set set : this.declaredPrefixes) {
            if (!set.contains(name.getPrefix() + name.getNamespaceURI())) continue;
            return;
        }
        writer.writeNamespace(name.getPrefix(), name.getNamespaceURI());
        this.declaredPrefixes.peek().add(name.getPrefix() + name.getNamespaceURI());
    }
}

