/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.dspace.xoai.model.oaipmh.Granularity;
import org.dspace.xoai.services.api.DateProvider;

public class UTCDateProvider
implements DateProvider {
    @Override
    public String format(Date date) {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format2.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format2.format(date);
    }

    @Override
    public Date now() {
        return new Date();
    }

    @Override
    public String format(Date date, Granularity granularity) {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (granularity == Granularity.Day) {
            format2 = new SimpleDateFormat("yyyy-MM-dd");
        }
        format2.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format2.format(date);
    }

    @Override
    public Date parse(String date, Granularity granularity) throws ParseException {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (granularity == Granularity.Day) {
            format2 = new SimpleDateFormat("yyyy-MM-dd");
        }
        format2.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format2.parse(date);
    }

    @Override
    public Date parse(String string2) throws ParseException {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format2.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return format2.parse(string2);
        }
        catch (ParseException e) {
            format2 = new SimpleDateFormat("yyyy-MM-dd");
            format2.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format2.parse(string2);
        }
    }
}

