/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.dspace.xoai.exceptions.InvalidResumptionTokenException;
import org.dspace.xoai.model.oaipmh.ResumptionToken;
import org.dspace.xoai.services.api.ResumptionTokenFormat;
import org.dspace.xoai.util.Base64Utils;

public class SimpleResumptionTokenFormat
implements ResumptionTokenFormat {
    @Override
    public ResumptionToken.Value parse(String resumptionToken) throws InvalidResumptionTokenException {
        String metadataPrefix;
        Date until2;
        Date from2;
        String set;
        int offset;
        block9: {
            if (resumptionToken == null) {
                return new ResumptionToken.Value();
            }
            offset = 0;
            set = null;
            from2 = null;
            until2 = null;
            metadataPrefix = null;
            if (resumptionToken == null || resumptionToken.trim().equals("")) {
                return new ResumptionToken.Value();
            }
            String s2 = Base64Utils.decode(resumptionToken);
            String[] pieces = s2.split(Pattern.quote("|"));
            try {
                if (pieces.length > 0) {
                    offset = Integer.parseInt(pieces[0].substring(2));
                    if (pieces.length > 1 && (set = pieces[1].substring(2)) != null && set.equals("")) {
                        set = null;
                    }
                    if (pieces.length > 2) {
                        from2 = this.stringToDate(pieces[2].substring(2));
                    }
                    if (pieces.length > 3) {
                        until2 = this.stringToDate(pieces[3].substring(2));
                    }
                    if (pieces.length > 4 && (metadataPrefix = pieces[4].substring(2)) != null && metadataPrefix.equals("")) {
                        metadataPrefix = null;
                    }
                    break block9;
                }
                throw new InvalidResumptionTokenException();
            }
            catch (Exception ex) {
                throw new InvalidResumptionTokenException(ex);
            }
        }
        return new ResumptionToken.Value().withUntil(until2).withFrom(from2).withMetadataPrefix(metadataPrefix).withOffset(offset).withSetSpec(set);
    }

    @Override
    public String format(ResumptionToken.Value resumptionToken) {
        String s2 = "1:" + resumptionToken.getOffset();
        s2 = s2 + "|2:";
        if (resumptionToken.hasSetSpec()) {
            s2 = s2 + resumptionToken.getSetSpec();
        }
        s2 = s2 + "|3:";
        if (resumptionToken.hasFrom()) {
            s2 = s2 + this.dateToString(resumptionToken.getFrom());
        }
        s2 = s2 + "|4:";
        if (resumptionToken.hasUntil()) {
            s2 = s2 + this.dateToString(resumptionToken.getUntil());
        }
        s2 = s2 + "|5:";
        if (resumptionToken.hasMetadataPrefix()) {
            s2 = s2 + resumptionToken.getMetadataPrefix();
        }
        return Base64Utils.encode(s2);
    }

    private String dateToString(Date date) {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return formatDate.format(date);
    }

    private Date stringToDate(String string2) {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            return formatDate.parse(string2);
        }
        catch (ParseException ex) {
            formatDate = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return formatDate.parse(string2);
            }
            catch (ParseException ex1) {
                return null;
            }
        }
    }
}

