/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.xoai.model.xoai.Element;
import org.dspace.xoai.model.xoai.Field;
import org.dspace.xoai.model.xoai.MetadataItem;
import org.dspace.xoai.model.xoai.XOAIMetadata;
import org.dspace.xoai.services.api.MetadataSearch;
import org.dspace.xoai.services.impl.AbstractMetadataSearcher;

public class MetadataSearcherItems
extends AbstractMetadataSearcher<MetadataItem>
implements MetadataSearch<MetadataItem> {
    public MetadataSearcherItems(XOAIMetadata metadata) {
        super(metadata);
    }

    @Override
    protected void consume(List<String> newNames, Element element) {
        ArrayList<String> names = new ArrayList<String>(newNames);
        names.add(element.getName());
        if (!element.getFields().isEmpty()) {
            this.add(StringUtils.join(names, "."), element.getFields());
        }
        if (!element.getElements().isEmpty()) {
            for (Element subElement : element.getElements()) {
                this.consume(names, subElement);
            }
        }
    }

    private void add(String name, List<Field> fields) {
        if (!this.index.containsKey(name)) {
            this.index.put(name, new ArrayList());
        }
        MetadataItem newElement = new MetadataItem();
        for (Field field2 : fields) {
            if (field2.getName() != null && !field2.getName().equals("value")) {
                newElement.addProperty(field2.getName(), field2.getValue());
                continue;
            }
            newElement.setValue(field2.getValue());
        }
        ((List)this.index.get(name)).add(newElement);
    }

    @Override
    public MetadataItem findOne(String xoaiPath) {
        return (MetadataItem)super.findOne(xoaiPath);
    }

    @Override
    public List<MetadataItem> findAll(String xoaiPath) {
        return super.findAll(xoaiPath);
    }
}

