/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.io.ByteArrayInputStream;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerException;
import org.dspace.xoai.model.oaipmh.About;
import org.dspace.xoai.model.oaipmh.Metadata;
import org.dspace.xoai.model.oaipmh.Record;
import org.dspace.xoai.serviceprovider.exceptions.InternalHarvestException;
import org.dspace.xoai.serviceprovider.model.Context;
import org.dspace.xoai.serviceprovider.parsers.HeaderParser;
import org.dspace.xoai.serviceprovider.parsers.MetadataParser;
import org.dspace.xoai.xml.XSLPipeline;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class RecordParser {
    private final Context context;
    private String metadataPrefix;

    public RecordParser(Context context, String metadataPrefix) {
        this.context = context;
        this.metadataPrefix = metadataPrefix;
    }

    public Record parse(XmlReader reader) throws XmlReaderException {
        HeaderParser headerParser = new HeaderParser();
        reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("header"))));
        Record record = new Record().withHeader(headerParser.parse(reader));
        if (!record.getHeader().isDeleted()) {
            reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("metadata")))).next(XmlEventMatchers.aStartElement());
            String content = reader.retrieveCurrentAsString();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
            XSLPipeline pipeline = new XSLPipeline(inputStream, true).apply(this.context.getMetadataTransformer(this.metadataPrefix));
            if (this.context.hasTransformer()) {
                pipeline.apply(this.context.getTransformer());
            }
            try {
                record.withMetadata(new Metadata(new MetadataParser().parse(pipeline.process())));
            }
            catch (TransformerException e) {
                throw new InternalHarvestException("Unable to process transformer");
            }
        }
        if (reader.next(this.aboutElement(), this.endOfRecord()).current(this.aboutElement())) {
            reader.next(XmlEventMatchers.aStartElement());
            record.withAbout(new About(reader.retrieveCurrentAsString()));
        }
        return record;
    }

    private Matcher<XMLEvent> endOfRecord() {
        return CoreMatchers.allOf(XmlEventMatchers.anEndElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("record"))));
    }

    private Matcher<XMLEvent> aboutElement() {
        return XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("about")));
    }
}

