/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import org.dspace.xoai.model.xoai.Element;
import org.dspace.xoai.model.xoai.Field;
import org.dspace.xoai.model.xoai.XOAIMetadata;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class MetadataParser {
    public XOAIMetadata parse(InputStream input2) throws XmlReaderException {
        XOAIMetadata metadata = new XOAIMetadata();
        XmlReader reader = new XmlReader(input2);
        reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("metadata"))));
        while (reader.next(XmlEventMatchers.theEndOfDocument(), XmlEventMatchers.anEndElement(), this.startElement()).current(this.startElement())) {
            metadata.withElement(this.parseElement(reader));
        }
        return metadata;
    }

    private Element parseElement(XmlReader reader) throws XmlReaderException {
        Element element = new Element(reader.getAttributeValue(this.name()));
        while (reader.next(this.startElement(), this.startField(), this.endOfMetadata()).current(this.startElement())) {
            element.withElement(this.parseElement(reader));
        }
        while (reader.current(this.startField())) {
            Field field2 = new Field().withName(reader.getAttributeValue(this.name()));
            if (reader.next(XmlEventMatchers.anEndElement(), XmlEventMatchers.text()).current(XmlEventMatchers.text())) {
                field2.withValue(reader.getText());
            }
            element.withField(field2);
            reader.next(this.startField(), this.endElement());
        }
        return element;
    }

    private Matcher<XMLEvent> startField() {
        return AllOf.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("field"))));
    }

    private Matcher<XMLEvent> endOfMetadata() {
        return AllOf.allOf(XmlEventMatchers.anEndElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("metadata"))));
    }

    private Matcher<QName> name() {
        return QNameMatchers.localPart(CoreMatchers.equalTo("name"));
    }

    private Matcher<XMLEvent> startElement() {
        return AllOf.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("element"))));
    }

    private Matcher<XMLEvent> endElement() {
        return AllOf.allOf(XmlEventMatchers.anEndElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("element"))));
    }
}

