/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.io.InputStream;
import javax.xml.stream.events.XMLEvent;
import org.dspace.xoai.model.oaipmh.Error;
import org.dspace.xoai.model.oaipmh.MetadataFormat;
import org.dspace.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class MetadataFormatParser {
    private final XmlReader reader;
    private boolean awaitingNextInvocation = false;

    public MetadataFormatParser(InputStream inputStream) {
        try {
            this.reader = new XmlReader(inputStream);
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    public boolean hasNext() throws XmlReaderException, IdDoesNotExistException {
        if (!this.awaitingNextInvocation) {
            this.reader.next(this.metadataElement(), this.errorElement(), XmlEventMatchers.theEndOfDocument());
            this.awaitingNextInvocation = true;
        }
        if (this.reader.current(this.errorElement())) {
            String code = this.reader.getAttributeValue(QNameMatchers.localPart(CoreMatchers.equalTo("code")));
            if (CoreMatchers.equalTo(Error.Code.NO_METADATA_FORMATS.code()).matches(code)) {
                return false;
            }
            if (Error.Code.ID_DOES_NOT_EXIST.code().equals(code)) {
                throw new IdDoesNotExistException();
            }
            throw new InvalidOAIResponse("OAI responded with code: " + code);
        }
        return this.reader.current(this.metadataElement());
    }

    private Matcher<XMLEvent> errorElement() {
        return XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("error")));
    }

    private Matcher<XMLEvent> metadataElement() {
        return CoreMatchers.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("metadataFormat"))));
    }

    public MetadataFormat next() throws XmlReaderException, IdDoesNotExistException {
        if (!this.hasNext()) {
            throw new XmlReaderException("No more metadata elements available");
        }
        this.awaitingNextInvocation = false;
        return new MetadataFormat().withMetadataPrefix(this.reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("metadataPrefix")))).next(XmlEventMatchers.text()).getText()).withSchema(this.reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("schema")))).next(XmlEventMatchers.text()).getText()).withMetadataNamespace(this.reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("metadataNamespace")))).next(XmlEventMatchers.text()).getText());
    }
}

