/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import org.dspace.xoai.model.oaipmh.Error;
import org.dspace.xoai.model.oaipmh.Set;
import org.dspace.xoai.serviceprovider.exceptions.EncapsulatedKnownException;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.exceptions.NoSetHierarchyException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ListSetsParser {
    private final XmlReader reader;
    private boolean awaitingNextInvocation = false;

    public ListSetsParser(XmlReader reader) {
        this.reader = reader;
    }

    public boolean hasNext() throws XmlReaderException {
        if (!this.awaitingNextInvocation) {
            this.reader.next(this.setElement(), this.errorElement(), this.resumptionToken(), XmlEventMatchers.theEndOfDocument());
        }
        this.awaitingNextInvocation = true;
        if (this.reader.current(this.errorElement())) {
            String code = this.reader.getAttributeValue(QNameMatchers.localPart(CoreMatchers.equalTo("code")));
            if (CoreMatchers.equalTo(Error.Code.NO_RECORDS_MATCH.code()).matches(code)) {
                return false;
            }
            if (CoreMatchers.equalTo(Error.Code.NO_SET_HIERARCHY.code()).matches(code)) {
                throw new EncapsulatedKnownException(new NoSetHierarchyException());
            }
            throw new InvalidOAIResponse("OAI responded with code: " + code);
        }
        return this.reader.current(this.setElement());
    }

    private Matcher<XMLEvent> resumptionToken() {
        return CoreMatchers.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("resumptionToken"))));
    }

    public Set next() throws XmlReaderException {
        if (!this.hasNext()) {
            throw new XmlReaderException("No more identifiers available");
        }
        this.awaitingNextInvocation = false;
        return this.parseSet();
    }

    private Set parseSet() throws XmlReaderException {
        Set set = new Set();
        String setName = null;
        String setSpec = null;
        while (setName == null || setSpec == null) {
            this.reader.next(XmlEventMatchers.aStartElement());
            QName elementName = this.reader.getName();
            this.reader.next(XmlEventMatchers.text());
            String extractedText = this.reader.getText();
            while (this.reader.next(XmlEventMatchers.anEndElement(), XmlEventMatchers.text()).current(XmlEventMatchers.text())) {
                extractedText = extractedText + this.reader.getText();
            }
            if (elementName.getLocalPart().equals("setName")) {
                setName = extractedText;
                continue;
            }
            if (!elementName.getLocalPart().equals("setSpec")) continue;
            setSpec = extractedText;
        }
        set.withName(setName);
        set.withSpec(setSpec);
        return set;
    }

    private Matcher<XMLEvent> errorElement() {
        return XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("error")));
    }

    private Matcher<XMLEvent> setElement() {
        return CoreMatchers.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("set"))));
    }

    private Matcher<XMLEvent> endSetElement() {
        return CoreMatchers.allOf(XmlEventMatchers.anEndElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("set"))));
    }

    public List<Set> parse() throws XmlReaderException {
        ArrayList<Set> sets = new ArrayList<Set>();
        while (this.hasNext()) {
            sets.add(this.next());
        }
        return sets;
    }
}

