/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import javax.xml.stream.events.XMLEvent;
import org.dspace.xoai.model.oaipmh.Error;
import org.dspace.xoai.model.oaipmh.Header;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.parsers.HeaderParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ListIdentifiersParser {
    private final XmlReader reader;
    private boolean awaitingNextInvocation = false;

    public ListIdentifiersParser(XmlReader reader) {
        this.reader = reader;
    }

    public boolean hasNext() throws XmlReaderException {
        if (!this.awaitingNextInvocation) {
            this.reader.next(this.headerElement(), this.errorElement(), this.resumptionToken(), XmlEventMatchers.theEndOfDocument());
        }
        this.awaitingNextInvocation = true;
        if (this.reader.current(this.errorElement())) {
            String code = this.reader.getAttributeValue(QNameMatchers.localPart(CoreMatchers.equalTo("code")));
            if (CoreMatchers.equalTo(Error.Code.NO_RECORDS_MATCH.code()).matches(code)) {
                return false;
            }
            throw new InvalidOAIResponse("OAI responded with code: " + code);
        }
        return this.reader.current(this.headerElement());
    }

    private Matcher<XMLEvent> resumptionToken() {
        return CoreMatchers.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("resumptionToken"))));
    }

    public Header next() throws XmlReaderException {
        if (!this.hasNext()) {
            throw new XmlReaderException("No more identifiers available");
        }
        this.awaitingNextInvocation = false;
        return new HeaderParser().parse(this.reader);
    }

    private Matcher<XMLEvent> errorElement() {
        return XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("error")));
    }

    private Matcher<XMLEvent> headerElement() {
        return CoreMatchers.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("header"))));
    }
}

