/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.io.InputStream;
import org.dspace.xoai.model.oaipmh.DeletedRecord;
import org.dspace.xoai.model.oaipmh.Description;
import org.dspace.xoai.model.oaipmh.Granularity;
import org.dspace.xoai.model.oaipmh.Identify;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.xml.IslandParsers;
import org.hamcrest.CoreMatchers;

public class IdentifyParser {
    private final XmlReader reader;

    public IdentifyParser(InputStream stream) {
        try {
            this.reader = new XmlReader(stream);
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    public Identify parse() {
        try {
            Identify identify = new Identify();
            this.reader.next(CoreMatchers.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("Identify")))));
            this.reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("repositoryName"))));
            identify.withRepositoryName(this.reader.next(XmlEventMatchers.text()).getText());
            this.reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("baseURL"))));
            identify.withBaseURL(this.reader.next(XmlEventMatchers.text()).getText());
            this.reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("protocolVersion"))));
            identify.withProtocolVersion(this.reader.next(XmlEventMatchers.text()).getText());
            this.reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("adminEmail")))).next(XmlEventMatchers.text());
            identify.withAdminEmail(this.reader.getText());
            while (this.reader.next(XmlEventMatchers.aStartElement()).current(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("adminEmail"))))) {
                identify.withAdminEmail(this.reader.next(XmlEventMatchers.text()).getText());
            }
            identify.withEarliestDatestamp(this.reader.next(XmlEventMatchers.text()).get(IslandParsers.dateParser()));
            this.reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("deletedRecord")))).next(XmlEventMatchers.text());
            identify.withDeletedRecord(DeletedRecord.fromValue(this.reader.getText()));
            this.reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("granularity")))).next(XmlEventMatchers.text());
            identify.withGranularity(Granularity.fromRepresentation(this.reader.getText()));
            while (this.reader.next(XmlEventMatchers.aStartElement(), XmlEventMatchers.theEndOfDocument()).current(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("compression"))))) {
                identify.withCompression(this.reader.next(XmlEventMatchers.text()).getText());
            }
            if (this.reader.current(XmlEventMatchers.theEndOfDocument())) {
                return identify;
            }
            if (this.reader.current(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("description"))))) {
                identify.withDescription(this.reader.get(this.descriptionParser()));
            }
            while (this.reader.next(XmlEventMatchers.aStartElement(), XmlEventMatchers.theEndOfDocument()).current(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("description"))))) {
                identify.withDescription(this.reader.get(this.descriptionParser()));
            }
            return identify;
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    private XmlReader.IslandParser<Description> descriptionParser() {
        return new XmlReader.IslandParser<Description>(){

            @Override
            public Description parse(XmlReader reader) throws XmlReaderException {
                return new Description(reader.retrieveCurrentAsString());
            }
        };
    }
}

