/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.AttributeMatchers;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import javax.xml.stream.events.XMLEvent;
import org.dspace.xoai.model.oaipmh.Header;
import org.dspace.xoai.serviceprovider.xml.IslandParsers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class HeaderParser {
    public Header parse(XmlReader reader) throws XmlReaderException {
        Header header = new Header();
        if (reader.hasAttribute(AttributeMatchers.attributeName(QNameMatchers.localPart(CoreMatchers.equalTo("status"))))) {
            header.withStatus(Header.Status.DELETED);
        }
        reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("identifier")))).next(XmlEventMatchers.text());
        header.withIdentifier(reader.getText());
        reader.next(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("datestamp")))).next(XmlEventMatchers.text());
        header.withDatestamp(reader.get(IslandParsers.dateParser()));
        while (reader.next(this.endOfHeader(), this.setSpecElement()).current(this.setSpecElement())) {
            header.withSetSpec(reader.next(XmlEventMatchers.text()).getText());
        }
        return header;
    }

    private Matcher<XMLEvent> setSpecElement() {
        return AllOf.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("setSpec"))));
    }

    private Matcher<XMLEvent> endOfHeader() {
        return AllOf.allOf(XmlEventMatchers.anEndElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("header"))));
    }
}

