/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parameters;

import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.dspace.xoai.model.oaipmh.Granularity;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.serviceprovider.parameters.GetRecordParameters;
import org.dspace.xoai.serviceprovider.parameters.ListIdentifiersParameters;
import org.dspace.xoai.serviceprovider.parameters.ListMetadataParameters;
import org.dspace.xoai.serviceprovider.parameters.ListRecordsParameters;
import org.dspace.xoai.services.api.DateProvider;
import org.dspace.xoai.services.impl.UTCDateProvider;
import org.dspace.xoai.util.URLEncoder;

public class Parameters {
    private static DateProvider formatter = new UTCDateProvider();
    private Verb.Type verb;
    private String metadataPrefix;
    private String set;
    private Date from;
    private Date until;
    private String identifier;
    private String resumptionToken;
    private String granularity;

    public static Parameters parameters() {
        return new Parameters();
    }

    public Parameters withVerb(Verb.Type verb) {
        this.verb = verb;
        return this;
    }

    public Parameters withUntil(Date until2) {
        this.until = until2;
        return this;
    }

    public Parameters withFrom(Date from2) {
        this.from = from2;
        return this;
    }

    public Parameters withSet(String value2) {
        this.set = value2;
        return this;
    }

    public Parameters identifier(String value2) {
        this.identifier = value2;
        return this;
    }

    public Parameters withResumptionToken(String value2) {
        this.resumptionToken = value2;
        this.metadataPrefix = null;
        this.until = null;
        this.set = null;
        this.from = null;
        return this;
    }

    public Parameters withoutResumptionToken() {
        this.resumptionToken = null;
        return this;
    }

    public Parameters withMetadataPrefix(String value2) {
        this.metadataPrefix = value2;
        return this;
    }

    public String toUrl(String baseUrl) {
        ArrayList<String> string2 = new ArrayList<String>();
        string2.add("verb=" + this.verb.name());
        Granularity granularity = this.granularity();
        if (this.set != null) {
            string2.add("set=" + URLEncoder.encode(this.set));
        }
        if (this.from != null) {
            string2.add("from=" + URLEncoder.encode(formatter.format(this.from, granularity)));
        }
        if (this.until != null) {
            string2.add("until=" + URLEncoder.encode(formatter.format(this.until, granularity)));
        }
        if (this.identifier != null) {
            string2.add("identifier=" + URLEncoder.encode(this.identifier));
        }
        if (this.metadataPrefix != null) {
            string2.add("metadataPrefix=" + URLEncoder.encode(this.metadataPrefix));
        }
        if (this.resumptionToken != null) {
            string2.add("resumptionToken=" + URLEncoder.encode(this.resumptionToken));
        }
        return baseUrl + "?" + StringUtils.join(string2, "&");
    }

    private Granularity granularity() {
        if (this.granularity != null) {
            for (int i = 0; i < Granularity.values().length; ++i) {
                Granularity possibleGranularity = Granularity.values()[i];
                if (!this.granularity.equals(possibleGranularity.toString())) continue;
                return possibleGranularity;
            }
        }
        return Granularity.Second;
    }

    public Parameters include(ListMetadataParameters parameters) {
        this.identifier = parameters.getIdentifier();
        return this;
    }

    public Parameters include(GetRecordParameters parameters) {
        this.identifier = parameters.getIdentifier();
        this.metadataPrefix = parameters.getMetadataPrefix();
        return this;
    }

    public Parameters include(ListRecordsParameters parameters) {
        this.metadataPrefix = parameters.getMetadataPrefix();
        this.set = parameters.getSetSpec();
        this.until = parameters.getUntil();
        this.from = parameters.getFrom();
        this.granularity = parameters.getGranularity();
        return this;
    }

    public Parameters include(ListIdentifiersParameters parameters) {
        this.metadataPrefix = parameters.getMetadataPrefix();
        this.set = parameters.getSetSpec();
        this.until = parameters.getUntil();
        this.from = parameters.getFrom();
        this.granularity = parameters.getGranularity();
        return this;
    }

    public Verb.Type getVerb() {
        return this.verb;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public String getSet() {
        return this.set;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getUntil() {
        return this.until;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getResumptionToken() {
        return this.resumptionToken;
    }

    public void withGranularity(String granularity) {
        this.granularity = granularity;
    }

    public Object getGranularity() {
        return this.granularity;
    }
}

