/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.handler;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.dspace.xoai.model.oaipmh.Record;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.serviceprovider.client.OAIClient;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.exceptions.OAIRequestException;
import org.dspace.xoai.serviceprovider.lazy.Source;
import org.dspace.xoai.serviceprovider.model.Context;
import org.dspace.xoai.serviceprovider.parameters.ListRecordsParameters;
import org.dspace.xoai.serviceprovider.parameters.Parameters;
import org.dspace.xoai.serviceprovider.parsers.ListRecordsParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class ListRecordHandler
implements Source<Record> {
    private Context context;
    private ListRecordsParameters parameters;
    private OAIClient client;
    private String resumptionToken;
    private boolean ended = false;

    public ListRecordHandler(Context context, ListRecordsParameters parameters) {
        this.context = context;
        this.parameters = parameters;
        this.client = context.getClient();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Record> nextIteration() {
        ArrayList<Record> arrayList;
        ArrayList<Record> records = new ArrayList<Record>();
        InputStream stream = null;
        try {
            block11: {
                block12: {
                    stream = this.resumptionToken == null ? this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListRecords).include(this.parameters)) : this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListRecords).include(this.parameters).withResumptionToken(this.resumptionToken));
                    XmlReader reader = new XmlReader(stream);
                    ListRecordsParser parser = new ListRecordsParser(reader, this.context, this.parameters.getMetadataPrefix());
                    while (parser.hasNext()) {
                        records.add(parser.next());
                    }
                    if (!reader.current(this.resumptionToken())) break block12;
                    if (reader.next(XmlEventMatchers.text(), XmlEventMatchers.anEndElement()).current(XmlEventMatchers.text())) {
                        String text2 = reader.getText();
                        if (text2 == null || "".equals(text2.trim())) {
                            this.ended = true;
                            break block11;
                        } else {
                            this.resumptionToken = text2;
                        }
                        break block11;
                    } else {
                        this.ended = true;
                    }
                    break block11;
                }
                this.ended = true;
            }
            stream.close();
            arrayList = records;
        }
        catch (XmlReaderException e) {
            try {
                throw new InvalidOAIResponse(e);
                catch (OAIRequestException e2) {
                    throw new InvalidOAIResponse(e2);
                }
                catch (IOException e3) {
                    throw new InvalidOAIResponse(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(stream);
        return arrayList;
    }

    private Matcher<XMLEvent> resumptionToken() {
        return AllOf.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("resumptionToken"))));
    }

    @Override
    public boolean endReached() {
        return this.ended;
    }
}

