/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.handler;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.dspace.xoai.model.oaipmh.Record;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.serviceprovider.client.OAIClient;
import org.dspace.xoai.serviceprovider.exceptions.CannotDisseminateFormatException;
import org.dspace.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.exceptions.OAIRequestException;
import org.dspace.xoai.serviceprovider.model.Context;
import org.dspace.xoai.serviceprovider.parameters.GetRecordParameters;
import org.dspace.xoai.serviceprovider.parameters.Parameters;
import org.dspace.xoai.serviceprovider.parsers.GetRecordParser;

public class GetRecordHandler {
    private final OAIClient client;
    private Context context;

    public GetRecordHandler(Context context) {
        this.context = context;
        this.client = context.getClient();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Record handle(GetRecordParameters parameters) throws IdDoesNotExistException, CannotDisseminateFormatException {
        Record record;
        InputStream stream = null;
        try {
            stream = this.client.execute(Parameters.parameters().withVerb(Verb.Type.GetRecord).include(parameters));
            Record record2 = new GetRecordParser(stream, this.context, parameters.getMetadataPrefix()).parse();
            stream.close();
            record = record2;
        }
        catch (OAIRequestException e) {
            try {
                throw new InvalidOAIResponse(e);
                catch (IOException e2) {
                    throw new InvalidOAIResponse(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(stream);
        return record;
    }
}

