/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.model.xoai;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.XmlWritable;
import com.lyncode.xml.XmlWriter;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.exceptions.XmlWriteException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.dspace.xoai.model.xoai.Element;
import org.dspace.xoai.services.api.MetadataSearch;
import org.dspace.xoai.services.impl.MetadataSearchImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.core.AllOf;

public class XOAIMetadata
implements XmlWritable {
    private static final String DEFAULT_FIELD = "value";
    public static final String NAMESPACE_URI = "http://www.lyncode.com/xoai";
    public static final String SCHEMA_LOCATION = "http://www.lyncode.com/xsd/xoai.xsd";
    protected List<Element> elements = new ArrayList<Element>();

    public static XOAIMetadata parse(InputStream inputStream) throws XmlReaderException {
        XmlReader reader = new XmlReader(inputStream);
        XOAIMetadata XOAIMetadata2 = new XOAIMetadata();
        if (!reader.next(XmlEventMatchers.aStartElement()).current(AllOf.allOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("metadata")))))) {
            throw new XmlReaderException("Invalid XML. Expecting entity 'metadata'");
        }
        while (reader.next(XmlEventMatchers.anElement()).current(XmlEventMatchers.aStartElement())) {
            if (reader.current(XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("element"))))) {
                XOAIMetadata2.withElement(Element.parse(reader));
                continue;
            }
            throw new XmlReaderException("Unexpected element");
        }
        if (!reader.current(AllOf.allOf(XmlEventMatchers.anEndElement(), XmlEventMatchers.elementName(QNameMatchers.localPart(CoreMatchers.equalTo("metadata")))))) {
            throw new XmlReaderException("Invalid XML. Expecting end of entity 'metadata'");
        }
        reader.close();
        return XOAIMetadata2;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public XOAIMetadata withElement(Element element) {
        this.elements.add(element);
        return this;
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.write(new XmlWriter(out));
        }
        catch (XmlWriteException xmlWriteException) {
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        return out.toString();
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            writer.setDefaultNamespace(NAMESPACE_URI);
            writer.writeStartElement("metadata");
            writer.writeDefaultNamespace(NAMESPACE_URI);
            writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.lyncode.com/xoai http://www.lyncode.com/xsd/xoai.xsd");
            for (Element element : this.getElements()) {
                writer.writeStartElement(NAMESPACE_URI, "element");
                element.write(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException(e);
        }
    }

    public MetadataSearch<String> searcher() {
        return new MetadataSearchImpl(this);
    }
}

