/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.model.oaipmh;

import com.google.common.base.Predicates;
import com.lyncode.xml.exceptions.XmlWriteException;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.dspace.xoai.model.oaipmh.Granularity;
import org.dspace.xoai.xml.XmlWritable;
import org.dspace.xoai.xml.XmlWriter;

public class ResumptionToken
implements XmlWritable {
    private final Value value;
    private Date expirationDate;
    private Long completeListSize;
    private Long cursor;

    public ResumptionToken(Value value2) {
        this.value = value2;
    }

    public ResumptionToken() {
        this.value = new Value();
    }

    public Value getValue() {
        return this.value;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public ResumptionToken withExpirationDate(Date value2) {
        this.expirationDate = value2;
        return this;
    }

    public Long getCompleteListSize() {
        return this.completeListSize;
    }

    public ResumptionToken withCompleteListSize(long value2) {
        this.completeListSize = value2;
        return this;
    }

    public Long getCursor() {
        return this.cursor;
    }

    public ResumptionToken withCursor(long value2) {
        this.cursor = value2;
        return this;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            if (this.expirationDate != null) {
                writer.writeAttribute("expirationDate", this.expirationDate, Granularity.Second);
            }
            if (this.completeListSize != null) {
                writer.writeAttribute("completeListSize", "" + this.completeListSize);
            }
            if (this.cursor != null) {
                writer.writeAttribute("cursor", "" + this.cursor);
            }
            if (this.value != null) {
                writer.write(this.value);
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException(e);
        }
    }

    public static class Value {
        private Long offset;
        private String set;
        private Date from;
        private Date until;
        private String metadataPrefix;

        public boolean isEmpty() {
            return Predicates.isNull().apply(this.offset) && Predicates.isNull().apply(this.set) && Predicates.isNull().apply(this.from) && Predicates.isNull().apply(this.until) && Predicates.isNull().apply(this.metadataPrefix);
        }

        public Value withOffset(long integer) {
            this.offset = integer;
            return this;
        }

        public Value withSetSpec(String setSpec) {
            this.set = setSpec;
            return this;
        }

        public Value withFrom(Date from2) {
            this.from = from2;
            return this;
        }

        public Value withUntil(Date until2) {
            this.until = until2;
            return this;
        }

        public Value withMetadataPrefix(String metadataPrefix) {
            this.metadataPrefix = metadataPrefix;
            return this;
        }

        public Value next(long sum2) {
            return new Value().withSetSpec(this.set).withFrom(this.from).withUntil(this.until).withMetadataPrefix(this.metadataPrefix).withOffset((this.offset == null ? 0L : this.offset) + sum2);
        }

        public Long getOffset() {
            return this.offset;
        }

        public String getSetSpec() {
            return this.set;
        }

        public Date getFrom() {
            return this.from;
        }

        public Date getUntil() {
            return this.until;
        }

        public String getMetadataPrefix() {
            return this.metadataPrefix;
        }

        public boolean hasOffset() {
            return this.offset != null;
        }

        public boolean hasSetSpec() {
            return this.set != null;
        }

        public boolean hasFrom() {
            return this.from != null;
        }

        public boolean hasUntil() {
            return this.until != null;
        }

        public boolean hasMetadataPrefix() {
            return this.metadataPrefix != null;
        }
    }
}

