/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.model.oaipmh;

import com.lyncode.xml.exceptions.XmlWriteException;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.xml.XmlWritable;
import org.dspace.xoai.xml.XmlWriter;

public class Request
implements XmlWritable {
    private final String baseUrl;
    private String verbType;
    private String identifier;
    private String metadataPrefix;
    private Date from;
    private Date until;
    private String set;
    private String resumptionToken;
    private String fromString;
    private String untilString;

    public Request(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Verb.Type getVerbType() {
        return Verb.Type.fromValue(this.verbType);
    }

    public String getVerb() {
        return this.verbType;
    }

    public Request withVerbType(Verb.Type value2) {
        this.verbType = value2.displayName();
        return this;
    }

    public Request withVerbType(String verb) {
        this.verbType = verb;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Request withIdentifier(String value2) {
        this.identifier = value2;
        return this;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public Request withMetadataPrefix(String value2) {
        this.metadataPrefix = value2;
        return this;
    }

    public Date getFrom() {
        return this.from;
    }

    public Request withFrom(Date value2) {
        this.from = value2;
        return this;
    }

    public Date getUntil() {
        return this.until;
    }

    public Request withUntil(Date value2) {
        this.until = value2;
        return this;
    }

    public String getSet() {
        return this.set;
    }

    public Request withSet(String value2) {
        this.set = value2;
        return this;
    }

    public String getResumptionToken() {
        return this.resumptionToken;
    }

    public Request withResumptionToken(String value2) {
        this.resumptionToken = value2;
        return this;
    }

    public Request withFrom(String value2) {
        this.fromString = value2;
        return this;
    }

    public Request withUntil(String value2) {
        this.untilString = value2;
        return this;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            writer.writeAttribute("verb", this.verbType);
            writer.writeAttribute("identifier", this.identifier);
            writer.writeAttribute("metadataPrefix", this.metadataPrefix);
            if (this.from != null) {
                writer.writeAttribute("from", this.from);
            } else {
                writer.writeAttribute("from", this.fromString);
            }
            if (this.until != null) {
                writer.writeAttribute("until", this.until);
            } else {
                writer.writeAttribute("until", this.untilString);
            }
            writer.writeAttribute("set", this.set);
            writer.writeAttribute("resumptionToken", this.resumptionToken);
            writer.writeCharacters(this.baseUrl);
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException(e);
        }
    }
}

