/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.model.oaipmh;

import com.lyncode.xml.exceptions.XmlWriteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.dspace.xoai.xml.XmlWritable;
import org.dspace.xoai.xml.XmlWriter;

public class Header
implements XmlWritable {
    protected String identifier;
    protected Date datestamp;
    protected List<String> setSpec = new ArrayList<String>();
    protected Status status;

    public String getIdentifier() {
        return this.identifier;
    }

    public Header withIdentifier(String value2) {
        this.identifier = value2;
        return this;
    }

    public Date getDatestamp() {
        return this.datestamp;
    }

    public Header withDatestamp(Date value2) {
        this.datestamp = value2;
        return this;
    }

    public List<String> getSetSpecs() {
        return this.setSpec;
    }

    public Status getStatus() {
        return this.status;
    }

    public Header withStatus(Status value2) {
        this.status = value2;
        return this;
    }

    public Header withSetSpec(String setSpec) {
        this.setSpec.add(setSpec);
        return this;
    }

    public boolean isDeleted() {
        return this.status != null;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            if (this.status != null) {
                writer.writeAttribute("status", this.status.value());
            }
            writer.writeElement("identifier", this.identifier);
            writer.writeElement("datestamp", this.datestamp);
            for (String setSpec : this.getSetSpecs()) {
                writer.writeElement("setSpec", setSpec);
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException(e);
        }
    }

    public static enum Status {
        DELETED("deleted");

        private final String representation;

        private Status(String representation) {
            this.representation = representation;
        }

        public String value() {
            return this.representation;
        }

        public static Status fromRepresentation(String representation) {
            for (Status status : Status.values()) {
                if (!status.representation.equals(representation)) continue;
                return status;
            }
            throw new IllegalArgumentException(representation);
        }
    }
}

