/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.dom;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.typed.SimpleValueEncoder;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DOMWrappingWriter
implements XMLStreamWriter2 {
    static final String DEFAULT_OUTPUT_ENCODING = "UTF-8";
    static final String DEFAULT_XML_VERSION = "1.0";
    protected final boolean mNsAware;
    protected final boolean mNsRepairing;
    protected String mEncoding = null;
    protected NamespaceContext mNsContext;
    protected final Document mDocument;
    protected SimpleValueEncoder mValueEncoder;

    protected DOMWrappingWriter(Node treeRoot, boolean nsAware, boolean nsRepairing) throws XMLStreamException {
        if (treeRoot == null) {
            throw new IllegalArgumentException("Can not pass null Node for constructing a DOM-based XMLStreamWriter");
        }
        this.mNsAware = nsAware;
        this.mNsRepairing = nsRepairing;
        switch (treeRoot.getNodeType()) {
            case 9: {
                this.mDocument = (Document)treeRoot;
                break;
            }
            case 1: {
                this.mDocument = treeRoot.getOwnerDocument();
                break;
            }
            case 11: {
                this.mDocument = treeRoot.getOwnerDocument();
                break;
            }
            default: {
                throw new XMLStreamException("Can not create an XMLStreamWriter for a DOM node of type " + treeRoot.getClass());
            }
        }
        if (this.mDocument == null) {
            throw new XMLStreamException("Can not create an XMLStreamWriter for given node (of type " + treeRoot.getClass() + "): did not have owner document");
        }
    }

    public void close() {
    }

    public void flush() {
    }

    public abstract NamespaceContext getNamespaceContext();

    public abstract String getPrefix(String var1);

    public abstract Object getProperty(String var1);

    public abstract void setDefaultNamespace(String var1);

    public void setNamespaceContext(NamespaceContext context) {
        this.mNsContext = context;
    }

    public abstract void setPrefix(String var1, String var2) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    public void writeCData(String data2) throws XMLStreamException {
        this.appendLeaf(this.mDocument.createCDATASection(data2));
    }

    public void writeCharacters(char[] text2, int start, int len) throws XMLStreamException {
        this.writeCharacters(new String(text2, start, len));
    }

    public void writeCharacters(String text2) throws XMLStreamException {
        this.appendLeaf(this.mDocument.createTextNode(text2));
    }

    public void writeComment(String data2) throws XMLStreamException {
        this.appendLeaf(this.mDocument.createCDATASection(data2));
    }

    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    public void writeDTD(String dtd) throws XMLStreamException {
        this.reportUnsupported("writeDTD()");
    }

    public abstract void writeEmptyElement(String var1) throws XMLStreamException;

    public abstract void writeEmptyElement(String var1, String var2) throws XMLStreamException;

    public abstract void writeEmptyElement(String var1, String var2, String var3) throws XMLStreamException;

    public abstract void writeEndDocument() throws XMLStreamException;

    public void writeEntityRef(String name) throws XMLStreamException {
        this.appendLeaf(this.mDocument.createEntityReference(name));
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, null);
    }

    public void writeProcessingInstruction(String target, String data2) throws XMLStreamException {
        this.appendLeaf(this.mDocument.createProcessingInstruction(target, data2));
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(DEFAULT_OUTPUT_ENCODING, DEFAULT_XML_VERSION);
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(null, version);
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.mEncoding = encoding;
    }

    public XMLStreamLocation2 getLocation() {
        return null;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public abstract boolean isPropertySupported(String var1);

    public abstract boolean setProperty(String var1, Object var2);

    public void writeCData(char[] text2, int start, int len) throws XMLStreamException {
        this.writeCData(new String(text2, start, len));
    }

    public abstract void writeDTD(String var1, String var2, String var3, String var4) throws XMLStreamException;

    public void writeFullEndElement() throws XMLStreamException {
        this.writeEndElement();
    }

    public void writeSpace(char[] text2, int start, int len) throws XMLStreamException {
        this.writeSpace(new String(text2, start, len));
    }

    public void writeSpace(String text2) throws XMLStreamException {
        this.writeCharacters(text2);
    }

    public void writeStartDocument(String version, String encoding, boolean standAlone) throws XMLStreamException {
        this.writeStartDocument(encoding, version);
    }

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        return null;
    }

    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h) {
        return null;
    }

    public void writeRaw(String text2) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    public void writeRaw(String text2, int start, int offset) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    public void writeRaw(char[] text2, int offset, int length) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    public void copyEventFromReader(XMLStreamReader2 r, boolean preserveEventData) throws XMLStreamException {
    }

    public void closeCompletely() {
    }

    public void writeBoolean(boolean value2) throws XMLStreamException {
        this.writeCharacters(value2 ? "true" : "false");
    }

    public void writeInt(int value2) throws XMLStreamException {
        this.writeCharacters(String.valueOf(value2));
    }

    public void writeLong(long value2) throws XMLStreamException {
        this.writeCharacters(String.valueOf(value2));
    }

    public void writeFloat(float value2) throws XMLStreamException {
        this.writeCharacters(String.valueOf(value2));
    }

    public void writeDouble(double value2) throws XMLStreamException {
        this.writeCharacters(String.valueOf(value2));
    }

    public void writeInteger(BigInteger value2) throws XMLStreamException {
        this.writeCharacters(value2.toString());
    }

    public void writeDecimal(BigDecimal value2) throws XMLStreamException {
        this.writeCharacters(value2.toString());
    }

    public void writeQName(QName name) throws XMLStreamException {
        this.writeCharacters(this.serializeQNameValue(name));
    }

    public void writeIntArray(int[] value2, int from2, int length) throws XMLStreamException {
        this.writeCharacters(this.getValueEncoder().encodeAsString(value2, from2, length));
    }

    public void writeLongArray(long[] value2, int from2, int length) throws XMLStreamException {
        this.writeCharacters(this.getValueEncoder().encodeAsString(value2, from2, length));
    }

    public void writeFloatArray(float[] value2, int from2, int length) throws XMLStreamException {
        this.writeCharacters(this.getValueEncoder().encodeAsString(value2, from2, length));
    }

    public void writeDoubleArray(double[] value2, int from2, int length) throws XMLStreamException {
        this.writeCharacters(this.getValueEncoder().encodeAsString(value2, from2, length));
    }

    public void writeBinary(byte[] value2, int from2, int length) throws XMLStreamException {
        this.writeBinary(Base64Variants.getDefaultVariant(), value2, from2, length);
    }

    public void writeBinary(Base64Variant v, byte[] value2, int from2, int length) throws XMLStreamException {
        this.writeCharacters(this.getValueEncoder().encodeAsString(v, value2, from2, length));
    }

    public void writeBooleanAttribute(String prefix, String nsURI, String localName, boolean value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, value2 ? "true" : "false");
    }

    public void writeIntAttribute(String prefix, String nsURI, String localName, int value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, String.valueOf(value2));
    }

    public void writeLongAttribute(String prefix, String nsURI, String localName, long value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, String.valueOf(value2));
    }

    public void writeFloatAttribute(String prefix, String nsURI, String localName, float value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, String.valueOf(value2));
    }

    public void writeDoubleAttribute(String prefix, String nsURI, String localName, double value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, String.valueOf(value2));
    }

    public void writeIntegerAttribute(String prefix, String nsURI, String localName, BigInteger value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, value2.toString());
    }

    public void writeDecimalAttribute(String prefix, String nsURI, String localName, BigDecimal value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, value2.toString());
    }

    public void writeQNameAttribute(String prefix, String nsURI, String localName, QName name) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.serializeQNameValue(name));
    }

    public void writeIntArrayAttribute(String prefix, String nsURI, String localName, int[] value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.getValueEncoder().encodeAsString(value2, 0, value2.length));
    }

    public void writeLongArrayAttribute(String prefix, String nsURI, String localName, long[] value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.getValueEncoder().encodeAsString(value2, 0, value2.length));
    }

    public void writeFloatArrayAttribute(String prefix, String nsURI, String localName, float[] value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.getValueEncoder().encodeAsString(value2, 0, value2.length));
    }

    public void writeDoubleArrayAttribute(String prefix, String nsURI, String localName, double[] value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.getValueEncoder().encodeAsString(value2, 0, value2.length));
    }

    public void writeBinaryAttribute(String prefix, String nsURI, String localName, byte[] value2) throws XMLStreamException {
        this.writeBinaryAttribute(Base64Variants.getDefaultVariant(), prefix, nsURI, localName, value2);
    }

    public void writeBinaryAttribute(Base64Variant v, String prefix, String nsURI, String localName, byte[] value2) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.getValueEncoder().encodeAsString(v, value2, 0, value2.length));
    }

    protected abstract void appendLeaf(Node var1) throws IllegalStateException;

    protected String serializeQNameValue(QName name) throws XMLStreamException {
        String prefix;
        if (this.mNsRepairing) {
            String uri = name.getNamespaceURI();
            NamespaceContext ctxt = this.getNamespaceContext();
            String string2 = prefix = ctxt == null ? null : ctxt.getPrefix(uri);
            if (prefix == null) {
                String origPrefix = name.getPrefix();
                if (origPrefix == null || origPrefix.length() == 0) {
                    prefix = "";
                    this.writeDefaultNamespace(uri);
                } else {
                    prefix = origPrefix;
                    this.writeNamespace(prefix, uri);
                }
            }
        } else {
            prefix = name.getPrefix();
        }
        String local = name.getLocalPart();
        if (prefix == null || prefix.length() == 0) {
            return local;
        }
        return prefix + ":" + local;
    }

    protected SimpleValueEncoder getValueEncoder() {
        if (this.mValueEncoder == null) {
            this.mValueEncoder = new SimpleValueEncoder();
        }
        return this.mValueEncoder;
    }

    protected static void throwOutputError(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg);
    }

    protected static void throwOutputError(String format2, Object arg) throws XMLStreamException {
        String msg = MessageFormat.format(format2, arg);
        DOMWrappingWriter.throwOutputError(msg);
    }

    protected void reportUnsupported(String operName) {
        throw new UnsupportedOperationException(operName + " can not be used with DOM-backed writer");
    }
}

