/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.AttributeInfo;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.codehaus.stax2.validation.DTDValidationSchema;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public abstract class Stax2ReaderImpl
implements XMLStreamReader2,
AttributeInfo,
DTDInfo,
LocationInfo {
    protected ValueDecoderFactory _decoderFactory;

    protected Stax2ReaderImpl() {
    }

    public Object getFeature(String name) {
        return null;
    }

    public void setFeature(String name, Object value2) {
    }

    public boolean isPropertySupported(String name) {
        return false;
    }

    public boolean setProperty(String name, Object value2) {
        return false;
    }

    public void skipElement() throws XMLStreamException {
        if (this.getEventType() != 1) {
            this.throwNotStartElem();
        }
        int nesting = 1;
        while (true) {
            int type;
            if ((type = this.next()) == 1) {
                ++nesting;
                continue;
            }
            if (type == 2 && --nesting == 0) break;
        }
    }

    public AttributeInfo getAttributeInfo() throws XMLStreamException {
        if (this.getEventType() != 1) {
            this.throwNotStartElem();
        }
        return this;
    }

    public DTDInfo getDTDInfo() throws XMLStreamException {
        if (this.getEventType() != 11) {
            return null;
        }
        return this;
    }

    public final LocationInfo getLocationInfo() {
        return this;
    }

    public int getText(Writer w, boolean preserveContents) throws IOException, XMLStreamException {
        char[] cbuf = this.getTextCharacters();
        int start = this.getTextStart();
        int len = this.getTextLength();
        if (len > 0) {
            w.write(cbuf, start, len);
        }
        return len;
    }

    public abstract int getDepth();

    public abstract boolean isEmptyElement() throws XMLStreamException;

    public abstract NamespaceContext getNonTransientNamespaceContext();

    public String getPrefixedName() {
        switch (this.getEventType()) {
            case 1: 
            case 2: {
                String prefix = this.getPrefix();
                String ln = this.getLocalName();
                if (prefix == null) {
                    return ln;
                }
                StringBuffer sb = new StringBuffer(ln.length() + 1 + prefix.length());
                sb.append(prefix);
                sb.append(':');
                sb.append(ln);
                return sb.toString();
            }
            case 9: {
                return this.getLocalName();
            }
            case 3: {
                return this.getPITarget();
            }
            case 11: {
                return this.getDTDRootName();
            }
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT, ENTITY_REFERENCE, PROCESSING_INSTRUCTION or DTD");
    }

    public void closeCompletely() throws XMLStreamException {
        this.close();
    }

    public int findAttributeIndex(String nsURI, String localName) {
        return -1;
    }

    public int getIdAttributeIndex() {
        return -1;
    }

    public int getNotationAttributeIndex() {
        return -1;
    }

    public Object getProcessedDTD() {
        return null;
    }

    public String getDTDRootName() {
        return null;
    }

    public String getDTDPublicId() {
        return null;
    }

    public String getDTDSystemId() {
        return null;
    }

    public String getDTDInternalSubset() {
        return null;
    }

    public DTDValidationSchema getProcessedDTDSchema() {
        return null;
    }

    public long getStartingByteOffset() {
        return -1L;
    }

    public long getStartingCharOffset() {
        return 0L;
    }

    public long getEndingByteOffset() throws XMLStreamException {
        return -1L;
    }

    public long getEndingCharOffset() throws XMLStreamException {
        return -1L;
    }

    public abstract XMLStreamLocation2 getStartLocation();

    public abstract XMLStreamLocation2 getCurrentLocation();

    public abstract XMLStreamLocation2 getEndLocation() throws XMLStreamException;

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        this.throwUnsupported();
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        this.throwUnsupported();
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        this.throwUnsupported();
        return null;
    }

    public abstract ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler var1);

    public boolean getElementAsBoolean() throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public int getElementAsInt() throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public long getElementAsLong() throws XMLStreamException {
        ValueDecoderFactory.LongDecoder dec = this._decoderFactory().getLongDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public float getElementAsFloat() throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder dec = this._decoderFactory().getFloatDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public double getElementAsDouble() throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder dec = this._decoderFactory().getDoubleDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public BigInteger getElementAsInteger() throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder dec = this._decoderFactory().getIntegerDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public BigDecimal getElementAsDecimal() throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder dec = this._decoderFactory().getDecimalDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public QName getElementAsQName() throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder dec = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getElementAs(dec);
        return dec.getValue();
    }

    public byte[] getElementAsBinary() throws XMLStreamException {
        return this.getElementAsBinary(Base64Variants.getDefaultVariant());
    }

    public abstract byte[] getElementAsBinary(Base64Variant var1) throws XMLStreamException;

    public void getElementAs(TypedValueDecoder tvd) throws XMLStreamException {
        String value2 = this.getElementText();
        try {
            tvd.decode(value2);
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, value2);
        }
    }

    public int readElementAsIntArray(int[] value2, int from2, int length) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getIntArrayDecoder(value2, from2, length));
    }

    public int readElementAsLongArray(long[] value2, int from2, int length) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getLongArrayDecoder(value2, from2, length));
    }

    public int readElementAsFloatArray(float[] value2, int from2, int length) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getFloatArrayDecoder(value2, from2, length));
    }

    public int readElementAsDoubleArray(double[] value2, int from2, int length) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getDoubleArrayDecoder(value2, from2, length));
    }

    public abstract int readElementAsArray(TypedArrayDecoder var1) throws XMLStreamException;

    public int readElementAsBinary(byte[] resultBuffer, int offset, int maxLength) throws XMLStreamException {
        return this.readElementAsBinary(Base64Variants.getDefaultVariant(), resultBuffer, offset, maxLength);
    }

    public abstract int readElementAsBinary(Base64Variant var1, byte[] var2, int var3, int var4) throws XMLStreamException;

    public abstract int getAttributeIndex(String var1, String var2);

    public boolean getAttributeAsBoolean(int index2) throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public int getAttributeAsInt(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public long getAttributeAsLong(int index2) throws XMLStreamException {
        ValueDecoderFactory.LongDecoder dec = this._decoderFactory().getLongDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public float getAttributeAsFloat(int index2) throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder dec = this._decoderFactory().getFloatDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public double getAttributeAsDouble(int index2) throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder dec = this._decoderFactory().getDoubleDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public BigInteger getAttributeAsInteger(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder dec = this._decoderFactory().getIntegerDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public BigDecimal getAttributeAsDecimal(int index2) throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder dec = this._decoderFactory().getDecimalDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public QName getAttributeAsQName(int index2) throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder dec = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public void getAttributeAs(int index2, TypedValueDecoder tvd) throws XMLStreamException {
        String value2 = this.getAttributeValue(index2);
        try {
            tvd.decode(value2);
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, value2);
        }
    }

    public int[] getAttributeAsIntArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntArrayDecoder dec = this._decoderFactory().getIntArrayDecoder();
        this.getAttributeAsArray(index2, dec);
        return dec.getValues();
    }

    public long[] getAttributeAsLongArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.LongArrayDecoder dec = this._decoderFactory().getLongArrayDecoder();
        this.getAttributeAsArray(index2, dec);
        return dec.getValues();
    }

    public float[] getAttributeAsFloatArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.FloatArrayDecoder dec = this._decoderFactory().getFloatArrayDecoder();
        this.getAttributeAsArray(index2, dec);
        return dec.getValues();
    }

    public double[] getAttributeAsDoubleArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.DoubleArrayDecoder dec = this._decoderFactory().getDoubleArrayDecoder();
        this.getAttributeAsArray(index2, dec);
        return dec.getValues();
    }

    public abstract int getAttributeAsArray(int var1, TypedArrayDecoder var2) throws XMLStreamException;

    public byte[] getAttributeAsBinary(int index2) throws XMLStreamException {
        return this.getAttributeAsBinary(Base64Variants.getDefaultVariant(), index2);
    }

    public abstract byte[] getAttributeAsBinary(Base64Variant var1, int var2) throws XMLStreamException;

    protected ValueDecoderFactory _decoderFactory() {
        if (this._decoderFactory == null) {
            this._decoderFactory = new ValueDecoderFactory();
        }
        return this._decoderFactory;
    }

    protected TypedXMLStreamException _constructTypeException(IllegalArgumentException iae, String lexicalValue) {
        return new TypedXMLStreamException(lexicalValue, iae.getMessage(), this.getStartLocation(), iae);
    }

    protected void throwUnsupported() throws XMLStreamException {
        throw new XMLStreamException("Unsupported method");
    }

    protected void throwNotStartElem() {
        throw new IllegalStateException("Current state not START_ELEMENT");
    }
}

