/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.trident;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kafka.api.OffsetRequest;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.javaapi.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import org.apache.storm.kafka.DynamicPartitionConnections;
import org.apache.storm.kafka.FailedFetchException;
import org.apache.storm.kafka.KafkaUtils;
import org.apache.storm.kafka.MessageMetadataSchemeAsMultiScheme;
import org.apache.storm.kafka.Partition;
import org.apache.storm.kafka.PartitionManager;
import org.apache.storm.kafka.TopicOffsetOutOfRangeException;
import org.apache.storm.kafka.trident.GlobalPartitionInformation;
import org.apache.storm.kafka.trident.MaxMetric;
import org.apache.storm.kafka.trident.TridentKafkaConfig;
import org.apache.storm.metric.api.CombinedMetric;
import org.apache.storm.metric.api.ICombiner;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IReducer;
import org.apache.storm.metric.api.MeanReducer;
import org.apache.storm.metric.api.ReducedMetric;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.IOpaquePartitionedTridentSpout;
import org.apache.storm.trident.spout.IPartitionedTridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TridentKafkaEmitter {
    private static final Logger LOG = LoggerFactory.getLogger(TridentKafkaEmitter.class);
    private DynamicPartitionConnections _connections;
    private String _topologyName;
    private KafkaUtils.KafkaOffsetMetric _kafkaOffsetMetric;
    private ReducedMetric _kafkaMeanFetchLatencyMetric;
    private CombinedMetric _kafkaMaxFetchLatencyMetric;
    private TridentKafkaConfig _config;
    private String _topologyInstanceId;

    public TridentKafkaEmitter(Map conf, TopologyContext context, TridentKafkaConfig config, String topologyInstanceId) {
        this._config = config;
        this._topologyInstanceId = topologyInstanceId;
        this._connections = new DynamicPartitionConnections(this._config, KafkaUtils.makeBrokerReader(conf, this._config));
        this._topologyName = (String)conf.get("topology.name");
        this._kafkaOffsetMetric = new KafkaUtils.KafkaOffsetMetric(this._connections);
        context.registerMetric("kafkaOffset", (IMetric)this._kafkaOffsetMetric, this._config.metricsTimeBucketSizeInSecs);
        this._kafkaMeanFetchLatencyMetric = context.registerMetric("kafkaFetchAvg", (IReducer)new MeanReducer(), this._config.metricsTimeBucketSizeInSecs);
        this._kafkaMaxFetchLatencyMetric = context.registerMetric("kafkaFetchMax", (ICombiner)new MaxMetric(), this._config.metricsTimeBucketSizeInSecs);
    }

    private Map failFastEmitNewPartitionBatch(TransactionAttempt attempt, TridentCollector collector, Partition partition2, Map lastMeta) {
        SimpleConsumer consumer = this._connections.register(partition2);
        Map ret = this.doEmitNewPartitionBatch(consumer, partition2, collector, lastMeta);
        Long offset = (Long)ret.get("offset");
        Long endOffset = (Long)ret.get("nextOffset");
        this._kafkaOffsetMetric.setOffsetData(partition2, new PartitionManager.OffsetData(endOffset, offset));
        return ret;
    }

    private Map emitNewPartitionBatch(TransactionAttempt attempt, TridentCollector collector, Partition partition2, Map lastMeta) {
        try {
            return this.failFastEmitNewPartitionBatch(attempt, collector, partition2, lastMeta);
        }
        catch (FailedFetchException e) {
            LOG.warn("Failed to fetch from partition " + partition2);
            if (lastMeta == null) {
                return null;
            }
            HashMap ret = new HashMap();
            ret.put("offset", lastMeta.get("nextOffset"));
            ret.put("nextOffset", lastMeta.get("nextOffset"));
            ret.put("partition", partition2.partition);
            ret.put("broker", ImmutableMap.of("host", partition2.host.host, "port", partition2.host.port));
            ret.put("topic", partition2.topic);
            ret.put("topology", ImmutableMap.of("name", this._topologyName, "id", this._topologyInstanceId));
            return ret;
        }
    }

    private Map doEmitNewPartitionBatch(SimpleConsumer consumer, Partition partition2, TridentCollector collector, Map lastMeta) {
        long offset;
        if (lastMeta != null) {
            String lastInstanceId = null;
            Map lastTopoMeta = (Map)lastMeta.get("topology");
            if (lastTopoMeta != null) {
                lastInstanceId = (String)lastTopoMeta.get("id");
            }
            offset = this._config.ignoreZkOffsets && !this._topologyInstanceId.equals(lastInstanceId) ? KafkaUtils.getOffset(consumer, partition2.topic, partition2.partition, this._config.startOffsetTime) : (Long)lastMeta.get("nextOffset");
        } else {
            offset = KafkaUtils.getOffset(consumer, partition2.topic, partition2.partition, this._config);
        }
        ByteBufferMessageSet msgs = null;
        try {
            msgs = this.fetchMessages(consumer, partition2, offset);
        }
        catch (TopicOffsetOutOfRangeException e) {
            long newOffset = KafkaUtils.getOffset(consumer, partition2.topic, partition2.partition, OffsetRequest.EarliestTime());
            LOG.warn("OffsetOutOfRange: Updating offset from offset = " + offset + " to offset = " + newOffset);
            offset = newOffset;
            msgs = KafkaUtils.fetchMessages(this._config, consumer, partition2, offset);
        }
        long endoffset = offset;
        for (MessageAndOffset msg : msgs) {
            this.emit(collector, msg.message(), partition2, msg.offset());
            endoffset = msg.nextOffset();
        }
        HashMap<String, Object> newMeta = new HashMap<String, Object>();
        newMeta.put("offset", offset);
        newMeta.put("nextOffset", endoffset);
        newMeta.put("instanceId", this._topologyInstanceId);
        newMeta.put("partition", partition2.partition);
        newMeta.put("broker", ImmutableMap.of("host", partition2.host.host, "port", partition2.host.port));
        newMeta.put("topic", partition2.topic);
        newMeta.put("topology", ImmutableMap.of("name", this._topologyName, "id", this._topologyInstanceId));
        return newMeta;
    }

    private ByteBufferMessageSet fetchMessages(SimpleConsumer consumer, Partition partition2, long offset) {
        long start = System.nanoTime();
        ByteBufferMessageSet msgs = null;
        msgs = KafkaUtils.fetchMessages(this._config, consumer, partition2, offset);
        long end = System.nanoTime();
        long millis = (end - start) / 1000000L;
        this._kafkaMeanFetchLatencyMetric.update((Object)millis);
        this._kafkaMaxFetchLatencyMetric.update((Object)millis);
        return msgs;
    }

    private void reEmitPartitionBatch(TransactionAttempt attempt, TridentCollector collector, Partition partition2, Map meta) {
        LOG.info("re-emitting batch, attempt " + attempt);
        String instanceId = (String)meta.get("instanceId");
        if (!this._config.ignoreZkOffsets || instanceId.equals(this._topologyInstanceId)) {
            SimpleConsumer consumer = this._connections.register(partition2);
            long offset = (Long)meta.get("offset");
            long nextOffset = (Long)meta.get("nextOffset");
            ByteBufferMessageSet msgs = null;
            msgs = this.fetchMessages(consumer, partition2, offset);
            if (msgs != null) {
                for (MessageAndOffset msg : msgs) {
                    if (offset == nextOffset) break;
                    if (offset > nextOffset) {
                        throw new RuntimeException("Error when re-emitting batch. overshot the end offset");
                    }
                    this.emit(collector, msg.message(), partition2, msg.offset());
                    offset = msg.nextOffset();
                }
            }
        }
    }

    private void emit(TridentCollector collector, Message msg, Partition partition2, long offset) {
        Iterable<List<Object>> values = this._config.scheme instanceof MessageMetadataSchemeAsMultiScheme ? KafkaUtils.generateTuples((MessageMetadataSchemeAsMultiScheme)this._config.scheme, msg, partition2, offset) : KafkaUtils.generateTuples(this._config, msg, partition2.topic);
        if (values != null) {
            for (List<Object> value2 : values) {
                collector.emit(value2);
            }
        }
    }

    private void clear() {
        this._connections.clear();
    }

    private List<Partition> orderPartitions(List<GlobalPartitionInformation> partitions) {
        ArrayList<Partition> part = new ArrayList<Partition>();
        for (GlobalPartitionInformation globalPartitionInformation : partitions) {
            part.addAll(globalPartitionInformation.getOrderedPartitions());
        }
        return part;
    }

    private void refresh(List<Partition> list2) {
        this._connections.clear();
        this._kafkaOffsetMetric.refreshPartitions(new HashSet<Partition>(list2));
    }

    public IOpaquePartitionedTridentSpout.Emitter<List<GlobalPartitionInformation>, Partition, Map> asOpaqueEmitter() {
        return new IOpaquePartitionedTridentSpout.Emitter<List<GlobalPartitionInformation>, Partition, Map>(){

            public Map emitPartitionBatch(TransactionAttempt transactionAttempt, TridentCollector tridentCollector, Partition partition2, Map map2) {
                return TridentKafkaEmitter.this.emitNewPartitionBatch(transactionAttempt, tridentCollector, partition2, map2);
            }

            public void refreshPartitions(List<Partition> partitions) {
                TridentKafkaEmitter.this.refresh(partitions);
            }

            public List<Partition> getOrderedPartitions(List<GlobalPartitionInformation> partitionInformation) {
                return TridentKafkaEmitter.this.orderPartitions(partitionInformation);
            }

            public void close() {
                TridentKafkaEmitter.this.clear();
            }
        };
    }

    public IPartitionedTridentSpout.Emitter asTransactionalEmitter() {
        return new IPartitionedTridentSpout.Emitter<List<GlobalPartitionInformation>, Partition, Map>(){

            public Map emitPartitionBatchNew(TransactionAttempt transactionAttempt, TridentCollector tridentCollector, Partition partition2, Map map2) {
                return TridentKafkaEmitter.this.failFastEmitNewPartitionBatch(transactionAttempt, tridentCollector, partition2, map2);
            }

            public void emitPartitionBatch(TransactionAttempt transactionAttempt, TridentCollector tridentCollector, Partition partition2, Map map2) {
                TridentKafkaEmitter.this.reEmitPartitionBatch(transactionAttempt, tridentCollector, partition2, map2);
            }

            public void refreshPartitions(List<Partition> partitions) {
                TridentKafkaEmitter.this.refresh(partitions);
            }

            public List<Partition> getOrderedPartitions(List<GlobalPartitionInformation> partitionInformation) {
                return TridentKafkaEmitter.this.orderPartitions(partitionInformation);
            }

            public void close() {
                TridentKafkaEmitter.this.clear();
            }
        };
    }
}

