/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.kafka.DynamicPartitionConnections;
import org.apache.storm.kafka.KafkaUtils;
import org.apache.storm.kafka.Partition;
import org.apache.storm.kafka.PartitionCoordinator;
import org.apache.storm.kafka.PartitionManager;
import org.apache.storm.kafka.SpoutConfig;
import org.apache.storm.kafka.StaticHosts;
import org.apache.storm.kafka.ZkState;
import org.apache.storm.kafka.trident.GlobalPartitionInformation;

public class StaticCoordinator
implements PartitionCoordinator {
    Map<Partition, PartitionManager> _managers = new HashMap<Partition, PartitionManager>();
    List<PartitionManager> _allManagers = new ArrayList<PartitionManager>();

    public StaticCoordinator(DynamicPartitionConnections connections, Map stormConf, SpoutConfig config, ZkState state, int taskIndex, int totalTasks, String topologyInstanceId) {
        StaticHosts hosts = (StaticHosts)config.hosts;
        ArrayList<GlobalPartitionInformation> partitions = new ArrayList<GlobalPartitionInformation>();
        partitions.add(hosts.getPartitionInformation());
        List<Partition> myPartitions = KafkaUtils.calculatePartitionsForTask(partitions, totalTasks, taskIndex);
        for (Partition myPartition : myPartitions) {
            this._managers.put(myPartition, new PartitionManager(connections, topologyInstanceId, state, stormConf, config, myPartition));
        }
        this._allManagers = new ArrayList<PartitionManager>(this._managers.values());
    }

    @Override
    public List<PartitionManager> getMyManagedPartitions() {
        return this._allManagers;
    }

    @Override
    public PartitionManager getManager(Partition partition2) {
        return this._managers.get(partition2);
    }

    @Override
    public void refresh() {
    }
}

