/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class DoubleMetaphone
implements StringEncoder {
    private static final String VOWELS = "AEIOUY";
    private static final String[] SILENT_START = new String[]{"GN", "KN", "PN", "WR", "PS"};
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE = new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " "};
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
    private static final String[] L_T_K_S_N_M_B_Z = new String[]{"L", "T", "K", "S", "N", "M", "B", "Z"};
    protected int maxCodeLen = 4;

    public String doubleMetaphone(String value2) {
        return this.doubleMetaphone(value2, false);
    }

    public String doubleMetaphone(String value2, boolean alternate) {
        if ((value2 = this.cleanInput(value2)) == null) {
            return null;
        }
        boolean slavoGermanic = this.isSlavoGermanic(value2);
        int index2 = this.isSilentStart(value2) ? 1 : 0;
        DoubleMetaphoneResult result2 = new DoubleMetaphoneResult(this.getMaxCodeLen());
        block25: while (!result2.isComplete() && index2 <= value2.length() - 1) {
            switch (value2.charAt(index2)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    index2 = this.handleAEIOUY(value2, result2, index2);
                    continue block25;
                }
                case 'B': {
                    result2.append('P');
                    index2 = this.charAt(value2, index2 + 1) == 'B' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case '\u00c7': {
                    result2.append('S');
                    ++index2;
                    continue block25;
                }
                case 'C': {
                    index2 = this.handleC(value2, result2, index2);
                    continue block25;
                }
                case 'D': {
                    index2 = this.handleD(value2, result2, index2);
                    continue block25;
                }
                case 'F': {
                    result2.append('F');
                    index2 = this.charAt(value2, index2 + 1) == 'F' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case 'G': {
                    index2 = this.handleG(value2, result2, index2, slavoGermanic);
                    continue block25;
                }
                case 'H': {
                    index2 = this.handleH(value2, result2, index2);
                    continue block25;
                }
                case 'J': {
                    index2 = this.handleJ(value2, result2, index2, slavoGermanic);
                    continue block25;
                }
                case 'K': {
                    result2.append('K');
                    index2 = this.charAt(value2, index2 + 1) == 'K' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case 'L': {
                    index2 = this.handleL(value2, result2, index2);
                    continue block25;
                }
                case 'M': {
                    result2.append('M');
                    index2 = this.conditionM0(value2, index2) ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case 'N': {
                    result2.append('N');
                    index2 = this.charAt(value2, index2 + 1) == 'N' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case '\u00d1': {
                    result2.append('N');
                    ++index2;
                    continue block25;
                }
                case 'P': {
                    index2 = this.handleP(value2, result2, index2);
                    continue block25;
                }
                case 'Q': {
                    result2.append('K');
                    index2 = this.charAt(value2, index2 + 1) == 'Q' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case 'R': {
                    index2 = this.handleR(value2, result2, index2, slavoGermanic);
                    continue block25;
                }
                case 'S': {
                    index2 = this.handleS(value2, result2, index2, slavoGermanic);
                    continue block25;
                }
                case 'T': {
                    index2 = this.handleT(value2, result2, index2);
                    continue block25;
                }
                case 'V': {
                    result2.append('F');
                    index2 = this.charAt(value2, index2 + 1) == 'V' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case 'W': {
                    index2 = this.handleW(value2, result2, index2);
                    continue block25;
                }
                case 'X': {
                    index2 = this.handleX(value2, result2, index2);
                    continue block25;
                }
                case 'Z': {
                    index2 = this.handleZ(value2, result2, index2, slavoGermanic);
                    continue block25;
                }
            }
            ++index2;
        }
        return alternate ? result2.getAlternate() : result2.getPrimary();
    }

    public Object encode(Object obj) throws EncoderException {
        if (!(obj instanceof String)) {
            throw new EncoderException("DoubleMetaphone encode parameter is not of type String");
        }
        return this.doubleMetaphone((String)obj);
    }

    public String encode(String value2) {
        return this.doubleMetaphone(value2);
    }

    public boolean isDoubleMetaphoneEqual(String value1, String value2) {
        return this.isDoubleMetaphoneEqual(value1, value2, false);
    }

    public boolean isDoubleMetaphoneEqual(String value1, String value2, boolean alternate) {
        return this.doubleMetaphone(value1, alternate).equals(this.doubleMetaphone(value2, alternate));
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    public void setMaxCodeLen(int maxCodeLen) {
        this.maxCodeLen = maxCodeLen;
    }

    private int handleAEIOUY(String value2, DoubleMetaphoneResult result2, int index2) {
        if (index2 == 0) {
            result2.append('A');
        }
        return index2 + 1;
    }

    private int handleC(String value2, DoubleMetaphoneResult result2, int index2) {
        if (this.conditionC0(value2, index2)) {
            result2.append('K');
            index2 += 2;
        } else if (index2 == 0 && DoubleMetaphone.contains(value2, index2, 6, "CAESAR")) {
            result2.append('S');
            index2 += 2;
        } else if (DoubleMetaphone.contains(value2, index2, 2, "CH")) {
            index2 = this.handleCH(value2, result2, index2);
        } else if (DoubleMetaphone.contains(value2, index2, 2, "CZ") && !DoubleMetaphone.contains(value2, index2 - 2, 4, "WICZ")) {
            result2.append('S', 'X');
            index2 += 2;
        } else if (DoubleMetaphone.contains(value2, index2 + 1, 3, "CIA")) {
            result2.append('X');
            index2 += 3;
        } else {
            if (DoubleMetaphone.contains(value2, index2, 2, "CC") && (index2 != 1 || this.charAt(value2, 0) != 'M')) {
                return this.handleCC(value2, result2, index2);
            }
            if (DoubleMetaphone.contains(value2, index2, 2, "CK", "CG", "CQ")) {
                result2.append('K');
                index2 += 2;
            } else if (DoubleMetaphone.contains(value2, index2, 2, "CI", "CE", "CY")) {
                if (DoubleMetaphone.contains(value2, index2, 3, "CIO", "CIE", "CIA")) {
                    result2.append('S', 'X');
                } else {
                    result2.append('S');
                }
                index2 += 2;
            } else {
                result2.append('K');
                index2 = DoubleMetaphone.contains(value2, index2 + 1, 2, " C", " Q", " G") ? (index2 += 3) : (DoubleMetaphone.contains(value2, index2 + 1, 1, "C", "K", "Q") && !DoubleMetaphone.contains(value2, index2 + 1, 2, "CE", "CI") ? (index2 += 2) : ++index2);
            }
        }
        return index2;
    }

    private int handleCC(String value2, DoubleMetaphoneResult result2, int index2) {
        if (DoubleMetaphone.contains(value2, index2 + 2, 1, "I", "E", "H") && !DoubleMetaphone.contains(value2, index2 + 2, 2, "HU")) {
            if (index2 == 1 && this.charAt(value2, index2 - 1) == 'A' || DoubleMetaphone.contains(value2, index2 - 1, 5, "UCCEE", "UCCES")) {
                result2.append("KS");
            } else {
                result2.append('X');
            }
            index2 += 3;
        } else {
            result2.append('K');
            index2 += 2;
        }
        return index2;
    }

    private int handleCH(String value2, DoubleMetaphoneResult result2, int index2) {
        if (index2 > 0 && DoubleMetaphone.contains(value2, index2, 4, "CHAE")) {
            result2.append('K', 'X');
            return index2 + 2;
        }
        if (this.conditionCH0(value2, index2)) {
            result2.append('K');
            return index2 + 2;
        }
        if (this.conditionCH1(value2, index2)) {
            result2.append('K');
            return index2 + 2;
        }
        if (index2 > 0) {
            if (DoubleMetaphone.contains(value2, 0, 2, "MC")) {
                result2.append('K');
            } else {
                result2.append('X', 'K');
            }
        } else {
            result2.append('X');
        }
        return index2 + 2;
    }

    private int handleD(String value2, DoubleMetaphoneResult result2, int index2) {
        if (DoubleMetaphone.contains(value2, index2, 2, "DG")) {
            if (DoubleMetaphone.contains(value2, index2 + 2, 1, "I", "E", "Y")) {
                result2.append('J');
                index2 += 3;
            } else {
                result2.append("TK");
                index2 += 2;
            }
        } else if (DoubleMetaphone.contains(value2, index2, 2, "DT", "DD")) {
            result2.append('T');
            index2 += 2;
        } else {
            result2.append('T');
            ++index2;
        }
        return index2;
    }

    private int handleG(String value2, DoubleMetaphoneResult result2, int index2, boolean slavoGermanic) {
        if (this.charAt(value2, index2 + 1) == 'H') {
            index2 = this.handleGH(value2, result2, index2);
        } else if (this.charAt(value2, index2 + 1) == 'N') {
            if (index2 == 1 && this.isVowel(this.charAt(value2, 0)) && !slavoGermanic) {
                result2.append("KN", "N");
            } else if (!DoubleMetaphone.contains(value2, index2 + 2, 2, "EY") && this.charAt(value2, index2 + 1) != 'Y' && !slavoGermanic) {
                result2.append("N", "KN");
            } else {
                result2.append("KN");
            }
            index2 += 2;
        } else if (DoubleMetaphone.contains(value2, index2 + 1, 2, "LI") && !slavoGermanic) {
            result2.append("KL", "L");
            index2 += 2;
        } else if (index2 == 0 && (this.charAt(value2, index2 + 1) == 'Y' || DoubleMetaphone.contains(value2, index2 + 1, 2, ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER))) {
            result2.append('K', 'J');
            index2 += 2;
        } else if (!(!DoubleMetaphone.contains(value2, index2 + 1, 2, "ER") && this.charAt(value2, index2 + 1) != 'Y' || DoubleMetaphone.contains(value2, 0, 6, "DANGER", "RANGER", "MANGER") || DoubleMetaphone.contains(value2, index2 - 1, 1, "E", "I") || DoubleMetaphone.contains(value2, index2 - 1, 3, "RGY", "OGY"))) {
            result2.append('K', 'J');
            index2 += 2;
        } else if (DoubleMetaphone.contains(value2, index2 + 1, 1, "E", "I", "Y") || DoubleMetaphone.contains(value2, index2 - 1, 4, "AGGI", "OGGI")) {
            if (DoubleMetaphone.contains(value2, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(value2, 0, 3, "SCH") || DoubleMetaphone.contains(value2, index2 + 1, 2, "ET")) {
                result2.append('K');
            } else if (DoubleMetaphone.contains(value2, index2 + 1, 4, "IER")) {
                result2.append('J');
            } else {
                result2.append('J', 'K');
            }
            index2 += 2;
        } else if (this.charAt(value2, index2 + 1) == 'G') {
            index2 += 2;
            result2.append('K');
        } else {
            ++index2;
            result2.append('K');
        }
        return index2;
    }

    private int handleGH(String value2, DoubleMetaphoneResult result2, int index2) {
        if (index2 > 0 && !this.isVowel(this.charAt(value2, index2 - 1))) {
            result2.append('K');
            index2 += 2;
        } else if (index2 == 0) {
            if (this.charAt(value2, index2 + 2) == 'I') {
                result2.append('J');
            } else {
                result2.append('K');
            }
            index2 += 2;
        } else if (index2 > 1 && DoubleMetaphone.contains(value2, index2 - 2, 1, "B", "H", "D") || index2 > 2 && DoubleMetaphone.contains(value2, index2 - 3, 1, "B", "H", "D") || index2 > 3 && DoubleMetaphone.contains(value2, index2 - 4, 1, "B", "H")) {
            index2 += 2;
        } else {
            if (index2 > 2 && this.charAt(value2, index2 - 1) == 'U' && DoubleMetaphone.contains(value2, index2 - 3, 1, "C", "G", "L", "R", "T")) {
                result2.append('F');
            } else if (index2 > 0 && this.charAt(value2, index2 - 1) != 'I') {
                result2.append('K');
            }
            index2 += 2;
        }
        return index2;
    }

    private int handleH(String value2, DoubleMetaphoneResult result2, int index2) {
        if ((index2 == 0 || this.isVowel(this.charAt(value2, index2 - 1))) && this.isVowel(this.charAt(value2, index2 + 1))) {
            result2.append('H');
            index2 += 2;
        } else {
            ++index2;
        }
        return index2;
    }

    private int handleJ(String value2, DoubleMetaphoneResult result2, int index2, boolean slavoGermanic) {
        if (DoubleMetaphone.contains(value2, index2, 4, "JOSE") || DoubleMetaphone.contains(value2, 0, 4, "SAN ")) {
            if (index2 == 0 && this.charAt(value2, index2 + 4) == ' ' || value2.length() == 4 || DoubleMetaphone.contains(value2, 0, 4, "SAN ")) {
                result2.append('H');
            } else {
                result2.append('J', 'H');
            }
            ++index2;
        } else {
            if (index2 == 0 && !DoubleMetaphone.contains(value2, index2, 4, "JOSE")) {
                result2.append('J', 'A');
            } else if (this.isVowel(this.charAt(value2, index2 - 1)) && !slavoGermanic && (this.charAt(value2, index2 + 1) == 'A' || this.charAt(value2, index2 + 1) == 'O')) {
                result2.append('J', 'H');
            } else if (index2 == value2.length() - 1) {
                result2.append('J', ' ');
            } else if (!DoubleMetaphone.contains(value2, index2 + 1, 1, L_T_K_S_N_M_B_Z) && !DoubleMetaphone.contains(value2, index2 - 1, 1, "S", "K", "L")) {
                result2.append('J');
            }
            index2 = this.charAt(value2, index2 + 1) == 'J' ? (index2 += 2) : ++index2;
        }
        return index2;
    }

    private int handleL(String value2, DoubleMetaphoneResult result2, int index2) {
        result2.append('L');
        if (this.charAt(value2, index2 + 1) == 'L') {
            if (this.conditionL0(value2, index2)) {
                result2.appendAlternate(' ');
            }
            index2 += 2;
        } else {
            ++index2;
        }
        return index2;
    }

    private int handleP(String value2, DoubleMetaphoneResult result2, int index2) {
        if (this.charAt(value2, index2 + 1) == 'H') {
            result2.append('F');
            index2 += 2;
        } else {
            result2.append('P');
            index2 = DoubleMetaphone.contains(value2, index2 + 1, 1, "P", "B") ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private int handleR(String value2, DoubleMetaphoneResult result2, int index2, boolean slavoGermanic) {
        if (index2 == value2.length() - 1 && !slavoGermanic && DoubleMetaphone.contains(value2, index2 - 2, 2, "IE") && !DoubleMetaphone.contains(value2, index2 - 4, 2, "ME", "MA")) {
            result2.appendAlternate('R');
        } else {
            result2.append('R');
        }
        return this.charAt(value2, index2 + 1) == 'R' ? index2 + 2 : index2 + 1;
    }

    private int handleS(String value2, DoubleMetaphoneResult result2, int index2, boolean slavoGermanic) {
        if (DoubleMetaphone.contains(value2, index2 - 1, 3, "ISL", "YSL")) {
            ++index2;
        } else if (index2 == 0 && DoubleMetaphone.contains(value2, index2, 5, "SUGAR")) {
            result2.append('X', 'S');
            ++index2;
        } else if (DoubleMetaphone.contains(value2, index2, 2, "SH")) {
            if (DoubleMetaphone.contains(value2, index2 + 1, 4, "HEIM", "HOEK", "HOLM", "HOLZ")) {
                result2.append('S');
            } else {
                result2.append('X');
            }
            index2 += 2;
        } else if (DoubleMetaphone.contains(value2, index2, 3, "SIO", "SIA") || DoubleMetaphone.contains(value2, index2, 4, "SIAN")) {
            if (slavoGermanic) {
                result2.append('S');
            } else {
                result2.append('S', 'X');
            }
            index2 += 3;
        } else if (index2 == 0 && DoubleMetaphone.contains(value2, index2 + 1, 1, "M", "N", "L", "W") || DoubleMetaphone.contains(value2, index2 + 1, 1, "Z")) {
            result2.append('S', 'X');
            index2 = DoubleMetaphone.contains(value2, index2 + 1, 1, "Z") ? index2 + 2 : index2 + 1;
        } else if (DoubleMetaphone.contains(value2, index2, 2, "SC")) {
            index2 = this.handleSC(value2, result2, index2);
        } else {
            if (index2 == value2.length() - 1 && DoubleMetaphone.contains(value2, index2 - 2, 2, "AI", "OI")) {
                result2.appendAlternate('S');
            } else {
                result2.append('S');
            }
            index2 = DoubleMetaphone.contains(value2, index2 + 1, 1, "S", "Z") ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private int handleSC(String value2, DoubleMetaphoneResult result2, int index2) {
        if (this.charAt(value2, index2 + 2) == 'H') {
            if (DoubleMetaphone.contains(value2, index2 + 3, 2, "OO", "ER", "EN", "UY", "ED", "EM")) {
                if (DoubleMetaphone.contains(value2, index2 + 3, 2, "ER", "EN")) {
                    result2.append("X", "SK");
                } else {
                    result2.append("SK");
                }
            } else if (index2 == 0 && !this.isVowel(this.charAt(value2, 3)) && this.charAt(value2, 3) != 'W') {
                result2.append('X', 'S');
            } else {
                result2.append('X');
            }
        } else if (DoubleMetaphone.contains(value2, index2 + 2, 1, "I", "E", "Y")) {
            result2.append('S');
        } else {
            result2.append("SK");
        }
        return index2 + 3;
    }

    private int handleT(String value2, DoubleMetaphoneResult result2, int index2) {
        if (DoubleMetaphone.contains(value2, index2, 4, "TION")) {
            result2.append('X');
            index2 += 3;
        } else if (DoubleMetaphone.contains(value2, index2, 3, "TIA", "TCH")) {
            result2.append('X');
            index2 += 3;
        } else if (DoubleMetaphone.contains(value2, index2, 2, "TH") || DoubleMetaphone.contains(value2, index2, 3, "TTH")) {
            if (DoubleMetaphone.contains(value2, index2 + 2, 2, "OM", "AM") || DoubleMetaphone.contains(value2, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(value2, 0, 3, "SCH")) {
                result2.append('T');
            } else {
                result2.append('0', 'T');
            }
            index2 += 2;
        } else {
            result2.append('T');
            index2 = DoubleMetaphone.contains(value2, index2 + 1, 1, "T", "D") ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private int handleW(String value2, DoubleMetaphoneResult result2, int index2) {
        if (DoubleMetaphone.contains(value2, index2, 2, "WR")) {
            result2.append('R');
            index2 += 2;
        } else if (index2 == 0 && (this.isVowel(this.charAt(value2, index2 + 1)) || DoubleMetaphone.contains(value2, index2, 2, "WH"))) {
            if (this.isVowel(this.charAt(value2, index2 + 1))) {
                result2.append('A', 'F');
            } else {
                result2.append('A');
            }
            ++index2;
        } else if (index2 == value2.length() - 1 && this.isVowel(this.charAt(value2, index2 - 1)) || DoubleMetaphone.contains(value2, index2 - 1, 5, "EWSKI", "EWSKY", "OWSKI", "OWSKY") || DoubleMetaphone.contains(value2, 0, 3, "SCH")) {
            result2.appendAlternate('F');
            ++index2;
        } else if (DoubleMetaphone.contains(value2, index2, 4, "WICZ", "WITZ")) {
            result2.append("TS", "FX");
            index2 += 4;
        } else {
            ++index2;
        }
        return index2;
    }

    private int handleX(String value2, DoubleMetaphoneResult result2, int index2) {
        if (index2 == 0) {
            result2.append('S');
            ++index2;
        } else {
            if (index2 != value2.length() - 1 || !DoubleMetaphone.contains(value2, index2 - 3, 3, "IAU", "EAU") && !DoubleMetaphone.contains(value2, index2 - 2, 2, "AU", "OU")) {
                result2.append("KS");
            }
            index2 = DoubleMetaphone.contains(value2, index2 + 1, 1, "C", "X") ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private int handleZ(String value2, DoubleMetaphoneResult result2, int index2, boolean slavoGermanic) {
        if (this.charAt(value2, index2 + 1) == 'H') {
            result2.append('J');
            index2 += 2;
        } else {
            if (DoubleMetaphone.contains(value2, index2 + 1, 2, "ZO", "ZI", "ZA") || slavoGermanic && index2 > 0 && this.charAt(value2, index2 - 1) != 'T') {
                result2.append("S", "TS");
            } else {
                result2.append('S');
            }
            index2 = this.charAt(value2, index2 + 1) == 'Z' ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private boolean conditionC0(String value2, int index2) {
        if (DoubleMetaphone.contains(value2, index2, 4, "CHIA")) {
            return true;
        }
        if (index2 <= 1) {
            return false;
        }
        if (this.isVowel(this.charAt(value2, index2 - 2))) {
            return false;
        }
        if (!DoubleMetaphone.contains(value2, index2 - 1, 3, "ACH")) {
            return false;
        }
        char c = this.charAt(value2, index2 + 2);
        return c != 'I' && c != 'E' || DoubleMetaphone.contains(value2, index2 - 2, 6, "BACHER", "MACHER");
    }

    private boolean conditionCH0(String value2, int index2) {
        if (index2 != 0) {
            return false;
        }
        if (!DoubleMetaphone.contains(value2, index2 + 1, 5, "HARAC", "HARIS") && !DoubleMetaphone.contains(value2, index2 + 1, 3, "HOR", "HYM", "HIA", "HEM")) {
            return false;
        }
        return !DoubleMetaphone.contains(value2, 0, 5, "CHORE");
    }

    private boolean conditionCH1(String value2, int index2) {
        return DoubleMetaphone.contains(value2, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(value2, 0, 3, "SCH") || DoubleMetaphone.contains(value2, index2 - 2, 6, "ORCHES", "ARCHIT", "ORCHID") || DoubleMetaphone.contains(value2, index2 + 2, 1, "T", "S") || (DoubleMetaphone.contains(value2, index2 - 1, 1, "A", "O", "U", "E") || index2 == 0) && (DoubleMetaphone.contains(value2, index2 + 2, 1, L_R_N_M_B_H_F_V_W_SPACE) || index2 + 1 == value2.length() - 1);
    }

    private boolean conditionL0(String value2, int index2) {
        if (index2 == value2.length() - 3 && DoubleMetaphone.contains(value2, index2 - 1, 4, "ILLO", "ILLA", "ALLE")) {
            return true;
        }
        return (DoubleMetaphone.contains(value2, index2 - 1, 2, "AS", "OS") || DoubleMetaphone.contains(value2, value2.length() - 1, 1, "A", "O")) && DoubleMetaphone.contains(value2, index2 - 1, 4, "ALLE");
    }

    private boolean conditionM0(String value2, int index2) {
        if (this.charAt(value2, index2 + 1) == 'M') {
            return true;
        }
        return DoubleMetaphone.contains(value2, index2 - 1, 3, "UMB") && (index2 + 1 == value2.length() - 1 || DoubleMetaphone.contains(value2, index2 + 2, 2, "ER"));
    }

    private boolean isSlavoGermanic(String value2) {
        return value2.indexOf(87) > -1 || value2.indexOf(75) > -1 || value2.indexOf("CZ") > -1 || value2.indexOf("WITZ") > -1;
    }

    private boolean isVowel(char ch) {
        return VOWELS.indexOf(ch) != -1;
    }

    private boolean isSilentStart(String value2) {
        boolean result2 = false;
        for (int i = 0; i < SILENT_START.length; ++i) {
            if (!value2.startsWith(SILENT_START[i])) continue;
            result2 = true;
            break;
        }
        return result2;
    }

    private String cleanInput(String input2) {
        if (input2 == null) {
            return null;
        }
        if ((input2 = input2.trim()).length() == 0) {
            return null;
        }
        return input2.toUpperCase();
    }

    protected char charAt(String value2, int index2) {
        if (index2 < 0 || index2 >= value2.length()) {
            return '\u0000';
        }
        return value2.charAt(index2);
    }

    private static boolean contains(String value2, int start, int length, String criteria) {
        return DoubleMetaphone.contains(value2, start, length, new String[]{criteria});
    }

    private static boolean contains(String value2, int start, int length, String criteria1, String criteria2) {
        return DoubleMetaphone.contains(value2, start, length, new String[]{criteria1, criteria2});
    }

    private static boolean contains(String value2, int start, int length, String criteria1, String criteria2, String criteria3) {
        return DoubleMetaphone.contains(value2, start, length, new String[]{criteria1, criteria2, criteria3});
    }

    private static boolean contains(String value2, int start, int length, String criteria1, String criteria2, String criteria3, String criteria4) {
        return DoubleMetaphone.contains(value2, start, length, new String[]{criteria1, criteria2, criteria3, criteria4});
    }

    private static boolean contains(String value2, int start, int length, String criteria1, String criteria2, String criteria3, String criteria4, String criteria5) {
        return DoubleMetaphone.contains(value2, start, length, new String[]{criteria1, criteria2, criteria3, criteria4, criteria5});
    }

    private static boolean contains(String value2, int start, int length, String criteria1, String criteria2, String criteria3, String criteria4, String criteria5, String criteria6) {
        return DoubleMetaphone.contains(value2, start, length, new String[]{criteria1, criteria2, criteria3, criteria4, criteria5, criteria6});
    }

    protected static boolean contains(String value2, int start, int length, String[] criteria) {
        boolean result2 = false;
        if (start >= 0 && start + length <= value2.length()) {
            String target = value2.substring(start, start + length);
            for (int i = 0; i < criteria.length; ++i) {
                if (!target.equals(criteria[i])) continue;
                result2 = true;
                break;
            }
        }
        return result2;
    }

    public class DoubleMetaphoneResult {
        private StringBuffer primary;
        private StringBuffer alternate;
        private int maxLength;

        public DoubleMetaphoneResult(int maxLength) {
            this.primary = new StringBuffer(DoubleMetaphone.this.getMaxCodeLen());
            this.alternate = new StringBuffer(DoubleMetaphone.this.getMaxCodeLen());
            this.maxLength = maxLength;
        }

        public void append(char value2) {
            this.appendPrimary(value2);
            this.appendAlternate(value2);
        }

        public void append(char primary, char alternate) {
            this.appendPrimary(primary);
            this.appendAlternate(alternate);
        }

        public void appendPrimary(char value2) {
            if (this.primary.length() < this.maxLength) {
                this.primary.append(value2);
            }
        }

        public void appendAlternate(char value2) {
            if (this.alternate.length() < this.maxLength) {
                this.alternate.append(value2);
            }
        }

        public void append(String value2) {
            this.appendPrimary(value2);
            this.appendAlternate(value2);
        }

        public void append(String primary, String alternate) {
            this.appendPrimary(primary);
            this.appendAlternate(alternate);
        }

        public void appendPrimary(String value2) {
            int addChars = this.maxLength - this.primary.length();
            if (value2.length() <= addChars) {
                this.primary.append(value2);
            } else {
                this.primary.append(value2.substring(0, addChars));
            }
        }

        public void appendAlternate(String value2) {
            int addChars = this.maxLength - this.alternate.length();
            if (value2.length() <= addChars) {
                this.alternate.append(value2);
            } else {
                this.alternate.append(value2.substring(0, addChars));
            }
        }

        public String getPrimary() {
            return this.primary.toString();
        }

        public String getAlternate() {
            return this.alternate.toString();
        }

        public boolean isComplete() {
            return this.primary.length() >= this.maxLength && this.alternate.length() >= this.maxLength;
        }
    }
}

