/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class DigestUtils {
    static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static MessageDigest getMd5Digest() {
        return DigestUtils.getDigest("MD5");
    }

    private static MessageDigest getShaDigest() {
        return DigestUtils.getDigest("SHA");
    }

    public static byte[] md5(byte[] data2) {
        return DigestUtils.getMd5Digest().digest(data2);
    }

    public static byte[] md5(String data2) {
        return DigestUtils.md5(data2.getBytes());
    }

    public static String md5Hex(byte[] data2) {
        return new String(Hex.encodeHex(DigestUtils.md5(data2)));
    }

    public static String md5Hex(String data2) {
        return new String(Hex.encodeHex(DigestUtils.md5(data2)));
    }

    public static byte[] sha(byte[] data2) {
        return DigestUtils.getShaDigest().digest(data2);
    }

    public static byte[] sha(String data2) {
        return DigestUtils.sha(data2.getBytes());
    }

    public static String shaHex(byte[] data2) {
        return new String(Hex.encodeHex(DigestUtils.sha(data2)));
    }

    public static String shaHex(String data2) {
        return new String(Hex.encodeHex(DigestUtils.sha(data2)));
    }
}

