/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.dps.AttributeStatistics;
import eu.europeana.cloud.service.dps.storm.utils.CassandraDAO;
import java.util.HashSet;
import java.util.Set;

public class CassandraAttributeStatisticsDAO
extends CassandraDAO {
    private static CassandraAttributeStatisticsDAO instance = null;
    private PreparedStatement updateAttributeStatement;
    private PreparedStatement selectAttributesStatement;

    public static synchronized CassandraAttributeStatisticsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = new CassandraAttributeStatisticsDAO(cassandra);
        }
        return instance;
    }

    private CassandraAttributeStatisticsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    @Override
    void prepareStatements() {
        this.updateAttributeStatement = this.dbService.getSession().prepare("UPDATE attribute_statistics SET occurrence = occurrence + ? WHERE task_id = ? AND node_xpath = ? AND node_value = ? AND attribute_name = ? AND attribute_value = ?");
        this.updateAttributeStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.selectAttributesStatement = this.dbService.getSession().prepare("SELECT * FROM attribute_statistics WHERE task_id = ? AND node_xpath = ? AND node_value = ? ");
        this.selectAttributesStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public void insertAttributeStatistics(long taskId, String nodeXpath, String nodeValue, Set<AttributeStatistics> attributes) {
        for (AttributeStatistics attributeStatistics : attributes) {
            this.insertAttributeStatistics(taskId, nodeXpath, nodeValue, attributeStatistics);
        }
    }

    public void insertAttributeStatistics(long taskId, String nodeXpath, String nodeValue, AttributeStatistics attributeStatistics) {
        this.dbService.getSession().execute(this.updateAttributeStatement.bind(attributeStatistics.getOccurrence(), taskId, nodeXpath, nodeValue, attributeStatistics.getName(), attributeStatistics.getValue()));
    }

    public Set<AttributeStatistics> getAttributeStatistics(long taskId, String nodeXpath, String nodeValue) {
        BoundStatement bs = this.selectAttributesStatement.bind(taskId, nodeXpath, nodeValue);
        ResultSet rs = this.dbService.getSession().execute(bs);
        HashSet<AttributeStatistics> result2 = new HashSet<AttributeStatistics>();
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            result2.add(new AttributeStatistics(row.getString("attribute_name"), row.getString("attribute_value"), row.getLong("occurrence")));
        }
        return result2;
    }
}

