/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.topologies.oaipmh.common;

import java.util.Date;
import java.util.Iterator;
import org.dspace.xoai.model.oaipmh.Granularity;
import org.dspace.xoai.model.oaipmh.MetadataFormat;
import org.dspace.xoai.serviceprovider.ServiceProvider;
import org.dspace.xoai.serviceprovider.client.HttpOAIClient;
import org.dspace.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.model.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAIHelper.class);
    private String resourceURL;

    public OAIHelper(String resourceURL) {
        this.resourceURL = resourceURL;
    }

    private ServiceProvider initServiceProvider() {
        HttpOAIClient client = new HttpOAIClient(this.resourceURL);
        return new ServiceProvider(new Context().withOAIClient(client));
    }

    public Iterator<MetadataFormat> listSchemas() {
        int retries = 10;
        while (true) {
            try {
                ServiceProvider serviceProvider = this.initServiceProvider();
                return serviceProvider.listMetadataFormats();
            }
            catch (InvalidOAIResponse e) {
                retries = this.handleExceptionWithRetries(retries, e, "Retrieving metadata schemas");
                continue;
            }
            catch (IdDoesNotExistException idDoesNotExistException) {
                continue;
            }
            break;
        }
    }

    public Date getEarlierDate() {
        int retries = 10;
        while (true) {
            try {
                ServiceProvider serviceProvider = this.initServiceProvider();
                return serviceProvider.identify().getEarliestDatestamp();
            }
            catch (InvalidOAIResponse e) {
                retries = this.handleExceptionWithRetries(retries, e, "Retrieving the earliest timestamp");
                continue;
            }
            break;
        }
    }

    public Granularity getGranularity() {
        int retries = 10;
        while (true) {
            try {
                ServiceProvider serviceProvider = this.initServiceProvider();
                return serviceProvider.identify().getGranularity();
            }
            catch (InvalidOAIResponse e) {
                retries = this.handleExceptionWithRetries(retries, e, "Retrieving the granularity");
                continue;
            }
            break;
        }
    }

    private int handleExceptionWithRetries(int retries, InvalidOAIResponse e, String message) {
        if (retries-- > 0) {
            LOGGER.warn("Error {} . Retries left: {}", (Object)message, (Object)retries);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                LOGGER.error(e1.getMessage());
            }
        } else {
            LOGGER.error("{} failed.", (Object)message);
            throw e;
        }
        return retries;
    }
}

