/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.topologies.oaipmh.bolt.harvester;

import eu.europeana.cloud.service.dps.storm.topologies.oaipmh.exceptions.HarvesterException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class XmlXPath {
    private final InputStream input;

    XmlXPath(InputStream input2) {
        this.input = input2;
    }

    InputStream xpath(String expression) throws HarvesterException, IOException {
        try {
            XPathExpression expr = this.compileExpression(expression);
            InputSource inputSource = new SAXSource(new InputSource(this.input)).getInputSource();
            NodeList result2 = (NodeList)expr.evaluate(inputSource, XPathConstants.NODESET);
            InputStream inputStream = this.convertToStream(result2);
            return inputStream;
        }
        catch (TransformerException | XPathExpressionException e) {
            throw new HarvesterException("Cannot xpath XML!", e);
        }
        finally {
            if (this.input != null) {
                this.input.close();
            }
        }
    }

    private XPathExpression compileExpression(String expression) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return xpath.compile(expression);
    }

    private InputStream convertToStream(NodeList nodes) throws TransformerException, HarvesterException {
        int length = nodes.getLength();
        if (length < 1) {
            throw new HarvesterException("Empty XML!");
        }
        if (length > 1) {
            throw new HarvesterException("More than one XML!");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource xmlSource = new DOMSource(nodes.item(0));
        StreamResult outputTarget = new StreamResult(outputStream);
        TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
        return new ByteArrayInputStream(outputStream.toByteArray());
    }
}

