/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.topologies.oaipmh.bolt.harvester;

import com.google.common.base.Throwables;
import eu.europeana.cloud.service.dps.storm.topologies.oaipmh.bolt.harvester.XmlXPath;
import eu.europeana.cloud.service.dps.storm.topologies.oaipmh.exceptions.HarvesterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.serviceprovider.client.HttpOAIClient;
import org.dspace.xoai.serviceprovider.parameters.GetRecordParameters;
import org.dspace.xoai.serviceprovider.parameters.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Harvester
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Harvester.class);
    private static final String METADATA_XPATH = "/*[local-name()='OAI-PMH']/*[local-name()='GetRecord']/*[local-name()='record']/*[local-name()='metadata']/child::*";

    public InputStream harvestRecord(String oaiPmhEndpoint, String recordId, String metadataPrefix) throws HarvesterException, IOException {
        GetRecordParameters params = new GetRecordParameters().withIdentifier(recordId).withMetadataFormatPrefix(metadataPrefix);
        int retries = 10;
        while (true) {
            try {
                HttpOAIClient client = new HttpOAIClient(oaiPmhEndpoint);
                InputStream record = client.execute(Parameters.parameters().withVerb(Verb.Type.GetRecord).include(params));
                return new XmlXPath(record).xpath(METADATA_XPATH);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOGGER.warn("Error harvesting record {}. Retries left:{} ", (Object)recordId, (Object)retries);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        LOGGER.error(Throwables.getStackTraceAsString(ex));
                    }
                    continue;
                }
                throw new HarvesterException(String.format("Problem with harvesting record %1$s for endpoint %2$s because of: %3$s", recordId, oaiPmhEndpoint, e.getMessage()), e);
            }
            break;
        }
    }
}

