/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.topologies.oaipmh.bolt;

import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.topologies.oaipmh.bolt.harvester.Harvester;
import eu.europeana.cloud.service.dps.storm.topologies.oaipmh.exceptions.HarvesterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordHarvestingBolt
extends AbstractDpsBolt {
    private Harvester harvester;
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordHarvestingBolt.class);

    @Override
    public void execute(StormTaskTuple stormTaskTuple) {
        String metadataPrefix;
        String recordId;
        String endpointLocation = this.readEndpointLocation(stormTaskTuple);
        if (this.parametersAreValid(endpointLocation, recordId = this.readRecordId(stormTaskTuple), metadataPrefix = this.readMetadataPrefix(stormTaskTuple))) {
            try {
                LOGGER.info("OAI Harvesting started for: {} and {}", (Object)recordId, (Object)endpointLocation);
                InputStream record = this.harvester.harvestRecord(endpointLocation, recordId, metadataPrefix);
                stormTaskTuple.setFileData(record);
                this.outputCollector.emit((List)stormTaskTuple.toStormTuple());
                LOGGER.info("Harvesting finished successfully for: {} and {}", (Object)recordId, (Object)endpointLocation);
            }
            catch (HarvesterException | IOException e) {
                LOGGER.error("Exception on harvesting", e);
                StringWriter stack = new StringWriter();
                e.printStackTrace(new PrintWriter(stack));
                this.emitErrorNotification(stormTaskTuple.getTaskId(), stormTaskTuple.getFileUrl(), "Cannot harvest data because: " + e.getMessage(), stack.toString());
                LOGGER.error(e.getMessage());
            }
        } else {
            this.emitErrorNotification(stormTaskTuple.getTaskId(), stormTaskTuple.getParameter("DPS_TASK_INPUT_DATA"), "Invalid parameters", null);
        }
    }

    @Override
    public void prepare() {
        this.harvester = new Harvester();
    }

    private boolean parametersAreValid(String endpointLocation, String recordId, String metadataPrefix) {
        return endpointLocation != null && recordId != null && metadataPrefix != null;
    }

    private String readEndpointLocation(StormTaskTuple stormTaskTuple) {
        return stormTaskTuple.getParameter("DPS_TASK_INPUT_DATA");
    }

    private String readRecordId(StormTaskTuple stormTaskTuple) {
        return stormTaskTuple.getParameter("CLOUD_LOCAL_IDENTIFIER");
    }

    private String readMetadataPrefix(StormTaskTuple stormTaskTuple) {
        return stormTaskTuple.getParameter("SCHEMA_NAME");
    }
}

