/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class DateAdapter
extends XmlAdapter<String, Date> {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    public String marshal(Date date) {
        if (date == null) {
            throw new RuntimeException("The revision creation Date shouldn't be null");
        }
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return this.dateFormat.format(date);
    }

    public Date unmarshal(String stringDate) throws ParseException {
        if (stringDate == null || stringDate.isEmpty()) {
            return null;
        }
        try {
            return this.dateFormat.parse(stringDate);
        }
        catch (ParseException e) {
            throw new ParseException(e.getMessage() + ". The accepted date format is yyyy-MM-dd'T'HH:mm:ss.SSSXXX", e.getErrorOffset());
        }
    }
}

