/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xml.matchers;

import com.lyncode.test.matchers.extractor.ExtractFunction;
import com.lyncode.test.matchers.extractor.MatcherExtractor;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AnyOf;

public class XmlEventMatchers {
    public static Matcher<XMLEvent> text() {
        return new TypeSafeMatcher<XMLEvent>(){

            @Override
            protected boolean matchesSafely(XMLEvent item) {
                return item.isCharacters();
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("is text");
            }
        };
    }

    public static Matcher<XMLEvent> aStartElement() {
        return new TypeSafeMatcher<XMLEvent>(){

            @Override
            protected boolean matchesSafely(XMLEvent item) {
                return item.isStartElement();
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("is start element");
            }
        };
    }

    public static Matcher<XMLEvent> anEndElement() {
        return new TypeSafeMatcher<XMLEvent>(){

            @Override
            protected boolean matchesSafely(XMLEvent item) {
                return item.isEndElement();
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("is end element");
            }
        };
    }

    public static Matcher<XMLEvent> theEndOfDocument() {
        return new TypeSafeMatcher<XMLEvent>(){

            @Override
            protected boolean matchesSafely(XMLEvent item) {
                return item.isEndDocument();
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("is the end of the document");
            }
        };
    }

    public static Matcher<XMLEvent> theStartOfDocument() {
        return new TypeSafeMatcher<XMLEvent>(){

            @Override
            protected boolean matchesSafely(XMLEvent item) {
                return item.isStartDocument();
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("is the start of the document");
            }
        };
    }

    public static Matcher<XMLEvent> anElement() {
        return AnyOf.anyOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.anEndElement());
    }

    public static Matcher<XMLEvent> anElementOr(Matcher<XMLEvent> matcher) {
        return AnyOf.anyOf(XmlEventMatchers.aStartElement(), XmlEventMatchers.anEndElement(), matcher);
    }

    public static Matcher<XMLEvent> hasAttributes() {
        return new TypeSafeMatcher<XMLEvent>(){

            @Override
            protected boolean matchesSafely(XMLEvent item) {
                return XmlEventMatchers.aStartElement().matches(item) && item.asStartElement().getAttributes().hasNext();
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("has attributes");
            }
        };
    }

    public static Matcher<XMLEvent> elementName(Matcher<QName> nameMatcher) {
        return new MatcherExtractor<XMLEvent, QName>(nameMatcher, XmlEventMatchers.extractName());
    }

    private static ExtractFunction<XMLEvent, QName> extractName() {
        return new ExtractFunction<XMLEvent, QName>(){

            @Override
            public QName apply(XMLEvent input2) {
                if (input2.isStartElement()) {
                    return input2.asStartElement().getName();
                }
                if (input2.isEndElement()) {
                    return input2.asEndElement().getName();
                }
                return null;
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("name");
            }
        };
    }
}

