/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.test.matchers.xml;

import com.lyncode.builder.MapBuilder;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class XPathMatchers {
    private static final String DEFAULT_PREFIX = "defprefix";

    private static String replaceXpath(String xpath) {
        int offset = 0;
        String newXpath = "";
        Pattern pattern = Pattern.compile("/[^/]+");
        Matcher matcher = pattern.matcher(xpath);
        while (matcher.find()) {
            if (matcher.start() > offset) {
                newXpath = newXpath + xpath.substring(offset, matcher.start());
            }
            newXpath = !matcher.group().contains(":") && !matcher.group().startsWith("/@") ? newXpath + "/defprefix:" + matcher.group().substring(1) : newXpath + matcher.group();
            offset = matcher.end() + 1;
        }
        return newXpath;
    }

    public static <T> XPathValueMatcher xPath(String expression, org.hamcrest.Matcher<T> value2) {
        return new XPathValueMatcher<T>(expression, value2);
    }

    public static <T> XPathValueMatcher xPath(String expression, org.hamcrest.Matcher<T> value2, String defaultNamespace) {
        return XPathMatchers.xPath(XPathMatchers.replaceXpath(expression), value2, new MapBuilder<String, String>().withPair(DEFAULT_PREFIX, defaultNamespace));
    }

    public static <T> XPathValueMatcher xPath(String expression, org.hamcrest.Matcher<T> value2, MapBuilder<String, String> namespaces) {
        return new XPathValueMatcher<T>(expression, value2, namespaces);
    }

    public static XPathMatcher hasXPath(String expression) {
        return new XPathMatcher(expression);
    }

    public static XPathMatcher hasXPath(String expression, String defaultNamespace) {
        return new XPathMatcher(XPathMatchers.replaceXpath(expression), new MapBuilder<String, String>().withPair(DEFAULT_PREFIX, defaultNamespace));
    }

    public static XPathMatcher hasXPath(String expression, MapBuilder<String, String> namespaces) {
        return new XPathMatcher(expression, namespaces);
    }

    private static class XPathValueMatcher<T>
    extends BaseMatcher<String> {
        private MapBuilder<String, String> namespaces;
        private org.hamcrest.Matcher<T> value;
        private String expression;

        public XPathValueMatcher(String expression, org.hamcrest.Matcher<T> value2) {
            this.value = value2;
            this.expression = expression;
        }

        public XPathValueMatcher(String expression, org.hamcrest.Matcher<T> value2, MapBuilder<String, String> namespaces) {
            this.value = value2;
            this.expression = expression;
            this.namespaces = namespaces;
        }

        @Override
        public boolean matches(Object o) {
            if (o instanceof String) {
                String input2 = (String)o;
                try {
                    Document document2 = DocumentHelper.parseText(input2);
                    XPath xPath = document2.createXPath(this.expression);
                    if (this.namespaces != null) {
                        xPath.setNamespaceURIs((Map)this.namespaces.build());
                    }
                    String evaluatedValue = xPath.valueOf(document2);
                    return !xPath.selectNodes(document2).isEmpty() && this.value.matches(evaluatedValue);
                }
                catch (DocumentException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            System.err.println("Incorrect input");
            return false;
        }

        @Override
        public void describeTo(Description description) {
            description.appendText("XPath ").appendValue(this.expression).appendText(" must resolve to ");
            this.value.describeTo(description);
        }
    }

    private static class XPathMatcher
    extends BaseMatcher<String> {
        private String expression;
        private MapBuilder<String, String> contexts;

        public XPathMatcher(String expression) {
            this.expression = expression;
        }

        public XPathMatcher(String expression, MapBuilder<String, String> namespaces) {
            this.expression = expression;
            this.contexts = namespaces;
        }

        @Override
        public boolean matches(Object o) {
            if (o instanceof String) {
                String input2 = (String)o;
                try {
                    List list2;
                    Document document2 = DocumentHelper.parseText(input2);
                    XPath xPath = document2.createXPath(this.expression);
                    if (this.contexts != null) {
                        xPath.setNamespaceURIs((Map)this.contexts.build());
                    }
                    boolean contains2 = !(list2 = xPath.selectNodes(document2)).isEmpty();
                    return contains2;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return false;
        }

        @Override
        public void describeTo(Description description) {
            description.appendText("XML with XPath ").appendValue(this.expression);
        }
    }
}

