/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.builder;

import com.lyncode.builder.Builder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListBuilder<T>
implements Builder<List<T>> {
    private List<T> list = new ArrayList<T>();

    public ListBuilder<T> add(Collection<T> list2) {
        this.list.addAll(list2);
        return this;
    }

    public ListBuilder<T> add(T ... list2) {
        for (T t : list2) {
            this.list.add(t);
        }
        return this;
    }

    @Override
    public List<T> build() {
        return this.list;
    }

    public <E> List<E> build(Transformer<T, E> transformer) {
        ArrayList<E> transformed = new ArrayList<E>();
        for (T elem2 : this.list) {
            transformed.add(transformer.transform(elem2));
        }
        return transformed;
    }

    public static abstract class Transformer<T, E> {
        public abstract E transform(T var1);
    }
}

