/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

public final class TextBuilder {
    private static final int MIN_LEN = 60;
    private static final int MAX_LEN = 120;
    private char[] mBuffer;
    private int[] mBufferOffsets;
    private int mBufferLen;
    private String mResultString;
    private int mEntryCount;

    public TextBuilder(int initialSize) {
        this.mBufferOffsets = new int[initialSize];
        int charSize = initialSize << 4;
        if (charSize < 60) {
            charSize = 60;
        } else if (charSize > 120) {
            charSize = 120;
        }
        this.mBuffer = new char[charSize];
    }

    public void reset() {
        this.mBufferLen = 0;
        this.mEntryCount = 0;
        this.mResultString = null;
    }

    public boolean isEmpty() {
        return this.mEntryCount == 0;
    }

    public int size() {
        return this.mEntryCount;
    }

    public String getEntry(int index2) {
        int len = this.mEntryCount;
        if (this.mResultString == null) {
            this.mResultString = new String(this.mBuffer, 0, this.mBufferLen);
        }
        if (index2 == 0 && len == 1) {
            return this.mResultString;
        }
        if (index2 == len - 1) {
            return this.mResultString.substring(this.mBufferOffsets[index2]);
        }
        return this.mResultString.substring(this.mBufferOffsets[index2], this.mBufferOffsets[index2 + 1]);
    }

    public int getOffset(int index2) {
        if (index2 >= this.mEntryCount) {
            return this.mBufferLen;
        }
        return this.mBufferOffsets[index2];
    }

    public char[] getCharBuffer() {
        return this.mBuffer;
    }

    public int getCharSize() {
        return this.mBufferLen;
    }

    public void startNewEntry() {
        if (this.mEntryCount >= this.mBufferOffsets.length) {
            int[] old = this.mBufferOffsets;
            this.mBufferOffsets = new int[old.length << 1];
            System.arraycopy(old, 0, this.mBufferOffsets, 0, old.length);
        }
        this.mBufferOffsets[this.mEntryCount] = this.mBufferLen;
        ++this.mEntryCount;
    }

    public void append(char c) {
        if (this.mBuffer.length == this.mBufferLen) {
            this.resize(1);
        }
        this.mBuffer[this.mBufferLen++] = c;
    }

    public void append(char[] src, int start, int len) {
        if (len > this.mBuffer.length - this.mBufferLen) {
            this.resize(len);
        }
        System.arraycopy(src, start, this.mBuffer, this.mBufferLen, len);
        this.mBufferLen += len;
    }

    public void setBufferSize(int newSize) {
        this.mBufferLen = newSize;
    }

    public char[] bufferFull(int needSpaceFor) {
        this.mBufferLen = this.mBuffer.length;
        this.resize(1);
        return this.mBuffer;
    }

    public String toString() {
        return new String(this.mBuffer, 0, this.mBufferLen);
    }

    private void resize(int needSpaceFor) {
        char[] old = this.mBuffer;
        int oldLen = old.length;
        int addition = oldLen >> 1;
        if (addition < (needSpaceFor -= oldLen - this.mBufferLen)) {
            addition = needSpaceFor;
        }
        this.mBuffer = new char[oldLen + addition];
        System.arraycopy(old, 0, this.mBuffer, 0, this.mBufferLen);
    }
}

