/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.compat.QNameCreator;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.CompactNsContext;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.sr.NsAttributeCollector;
import com.ctc.wstx.sr.NsDefaultProvider;
import com.ctc.wstx.util.BaseNsContext;
import com.ctc.wstx.util.EmptyNamespaceContext;
import com.ctc.wstx.util.InternCache;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.TextBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.SingletonIterator;
import org.codehaus.stax2.validation.XMLValidator;

public final class NsInputElementStack
extends InputElementStack {
    static final int IX_PREFIX = 0;
    static final int IX_LOCALNAME = 1;
    static final int IX_URI = 2;
    static final int IX_DEFAULT_NS = 3;
    static final int ENTRY_SIZE = 4;
    protected static final InternCache sInternCache = InternCache.getInstance();
    protected final NsAttributeCollector mAttrCollector;
    protected NsDefaultProvider mNsDefaultProvider;
    protected final StringVector mNamespaces = new StringVector(64);
    protected String[] mElements;
    protected int mSize = 0;
    protected int[] mNsCounts;
    protected boolean mMayHaveNsDefaults = false;
    protected String mLastLocalName = null;
    protected String mLastPrefix = null;
    protected String mLastNsURI = null;
    protected QName mLastName = null;
    protected BaseNsContext mLastNsContext = null;

    public NsInputElementStack(int initialSize, ReaderConfig cfg) {
        super(cfg);
        if (initialSize < 4) {
            initialSize = 4;
        }
        this.mElements = new String[initialSize << 2];
        this.mNsCounts = new int[initialSize];
        this.mAttrCollector = new NsAttributeCollector(cfg);
    }

    protected void setAutomaticDTDValidator(XMLValidator validator, NsDefaultProvider nsDefs) {
        this.mNsDefaultProvider = nsDefs;
        this.addValidator(validator);
    }

    public final void push(String prefix, String localName) {
        Object[] old;
        int index2 = this.mSize;
        if (index2 == this.mElements.length) {
            old = this.mElements;
            this.mElements = new String[old.length + 64];
            System.arraycopy(old, 0, this.mElements, 0, old.length);
        }
        this.mElements[index2] = prefix;
        this.mElements[index2 + 1] = localName;
        if (index2 == 0) {
            this.mElements[3] = "";
        } else {
            this.mElements[index2 + 3] = this.mElements[index2 - 1];
        }
        this.mSize = index2 + 4;
        if ((index2 >>= 2) == this.mNsCounts.length) {
            old = this.mNsCounts;
            this.mNsCounts = new int[old.length + 16];
            System.arraycopy(old, 0, this.mNsCounts, 0, old.length);
        }
        this.mNsCounts[index2] = this.mNamespaces.size();
        this.mAttrCollector.reset();
        if (this.mNsDefaultProvider != null) {
            this.mMayHaveNsDefaults = this.mNsDefaultProvider.mayHaveNsDefaults(prefix, localName);
        }
    }

    public final void push(String fullName) {
        throw new IllegalStateException("Internal error: push(fullName) shouldn't be called for namespace aware element stack.");
    }

    public boolean pop() throws XMLStreamException {
        if (this.mSize == 0) {
            throw new IllegalStateException("Popping from empty stack.");
        }
        this.mSize -= 4;
        int index2 = this.mSize;
        this.mElements[index2] = null;
        this.mElements[index2 + 1] = null;
        this.mElements[index2 + 2] = null;
        this.mElements[index2 + 3] = null;
        int nsCount = this.mNamespaces.size() - this.mNsCounts[index2 >> 2];
        if (nsCount > 0) {
            this.mLastNsContext = null;
            this.mNamespaces.removeLast(nsCount);
        }
        return index2 > 0;
    }

    public int resolveAndValidateElement() throws XMLStreamException {
        int xmlidIx;
        String ns;
        String prefix;
        if (this.mSize == 0) {
            throw new IllegalStateException("Calling validate() on empty stack.");
        }
        NsAttributeCollector ac = this.mAttrCollector;
        int nsCount = ac.getNsCount();
        if (nsCount > 0) {
            this.mLastNsContext = null;
            String[] nsPrefixes = ac.getNsPrefixes();
            TextBuilder nsURIs = ac.getNsURIs();
            boolean internNsUris = this.mConfig.willInternNsURIs();
            for (int i = 0; i < nsCount; ++i) {
                String prefix2;
                String nsUri = nsURIs.getEntry(i);
                if (internNsUris && nsUri.length() > 0) {
                    nsUri = sInternCache.intern(nsUri);
                }
                if ((prefix2 = nsPrefixes[i]) == "xmlns") {
                    this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XMLNS);
                    continue;
                }
                if (prefix2 == "xml") {
                    if (nsUri.equals("http://www.w3.org/XML/1998/namespace")) continue;
                    this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XML, nsUri, null);
                    continue;
                }
                if (nsUri == null || nsUri.length() == 0) {
                    nsUri = "";
                }
                if (prefix2 == null) {
                    this.mElements[this.mSize - 1] = nsUri;
                }
                if (internNsUris) {
                    if (nsUri == "http://www.w3.org/XML/1998/namespace") {
                        this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix2, null);
                    } else if (nsUri == "http://www.w3.org/2000/xmlns/") {
                        this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI);
                    }
                } else if (nsUri.equals("http://www.w3.org/XML/1998/namespace")) {
                    this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix2, null);
                } else if (nsUri.equals("http://www.w3.org/2000/xmlns/")) {
                    this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI);
                }
                this.mNamespaces.addStrings(prefix2, nsUri);
            }
        }
        if (this.mMayHaveNsDefaults) {
            this.mNsDefaultProvider.checkNsDefaults(this);
        }
        if ((prefix = this.mElements[this.mSize - 4]) == null) {
            ns = this.mElements[this.mSize - 1];
        } else if (prefix == "xml") {
            ns = "http://www.w3.org/XML/1998/namespace";
        } else {
            ns = this.mNamespaces.findLastFromMap(prefix);
            if (ns == null || ns.length() == 0) {
                this.mReporter.throwParseError(ErrorConsts.ERR_NS_UNDECLARED, prefix, null);
            }
        }
        this.mElements[this.mSize - 2] = ns;
        this.mIdAttrIndex = xmlidIx = ac.resolveNamespaces(this.mReporter, this.mNamespaces);
        XMLValidator vld = this.mValidator;
        if (vld == null) {
            if (xmlidIx >= 0) {
                this.normalizeXmlIdAttr(ac, xmlidIx);
            }
            return 4;
        }
        vld.validateElementStart(this.mElements[this.mSize - 3], this.mElements[this.mSize - 2], prefix);
        StringVector attrNames = ac.getNameList();
        int attrLen = ac.getCount();
        if (attrLen > 0) {
            attrLen += attrLen;
            String[] attrURIs = ac.getAttrURIs();
            String[] nameData = attrNames.getInternalArray();
            TextBuilder attrBuilder = ac.getAttrBuilder();
            char[] attrCB = attrBuilder.getCharBuffer();
            int i = 0;
            int nr = 0;
            while (i < attrLen) {
                String ln = nameData[i + 1];
                prefix = nameData[i];
                String normValue = this.mValidator.validateAttribute(ln, attrURIs[nr], prefix, attrCB, attrBuilder.getOffset(nr), attrBuilder.getOffset(nr + 1));
                if (normValue != null) {
                    ac.setNormalizedValue(nr, normValue);
                }
                i += 2;
                ++nr;
            }
        }
        return this.mValidator.validateElementAndAttributes();
    }

    public int validateEndElement() throws XMLStreamException {
        if (this.mValidator == null) {
            return 4;
        }
        int index2 = this.mSize - 4;
        int result2 = this.mValidator.validateElementEnd(this.mElements[index2 + 1], this.mElements[index2 + 2], this.mElements[index2 + 0]);
        if (index2 == 0) {
            this.mValidator.validationCompleted(true);
        }
        return result2;
    }

    public final AttributeCollector getAttrCollector() {
        return this.mAttrCollector;
    }

    public final BaseNsContext createNonTransientNsContext(Location loc) {
        if (this.mLastNsContext != null) {
            return this.mLastNsContext;
        }
        int totalNsSize = this.mNamespaces.size();
        if (totalNsSize < 1) {
            this.mLastNsContext = EmptyNamespaceContext.getInstance();
            return this.mLastNsContext;
        }
        int localCount = this.getCurrentNsCount() << 1;
        CompactNsContext nsCtxt = new CompactNsContext(loc, this.getDefaultNsURI(), this.mNamespaces.asArray(), totalNsSize, totalNsSize - localCount);
        if (localCount == 0) {
            this.mLastNsContext = nsCtxt;
        }
        return nsCtxt;
    }

    public final String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (prefix.length() == 0) {
            if (this.mSize == 0) {
                return "";
            }
            return this.mElements[this.mSize - 1];
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.mNamespaces.findLastNonInterned(prefix);
    }

    public final String getPrefix(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        String prefix = null;
        String[] strs = this.mNamespaces.getInternalArray();
        int len = this.mNamespaces.size();
        block0: for (int index2 = len - 1; index2 > 0; index2 -= 2) {
            if (!nsURI.equals(strs[index2])) continue;
            prefix = strs[index2 - 1];
            for (int j = index2 + 1; j < len; j += 2) {
                if (strs[j] != prefix) continue;
                prefix = null;
                continue block0;
            }
            if (prefix != null) break;
            prefix = "";
            break;
        }
        return prefix;
    }

    public final Iterator getPrefixes(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return new SingletonIterator("xml");
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return new SingletonIterator("xmlns");
        }
        String[] strs = this.mNamespaces.getInternalArray();
        int len = this.mNamespaces.size();
        ArrayList<String> l = null;
        block0: for (int index2 = len - 1; index2 > 0; index2 -= 2) {
            if (!nsURI.equals(strs[index2])) continue;
            String prefix = strs[index2 - 1];
            for (int j = index2 + 1; j < len; j += 2) {
                if (strs[j] == prefix) continue block0;
            }
            if (l == null) {
                l = new ArrayList<String>();
            }
            l.add(prefix);
        }
        return l == null ? EmptyIterator.getInstance() : l.iterator();
    }

    public final int getAttributeCount() {
        return this.mAttrCollector.getCount();
    }

    public final int findAttributeIndex(String nsURI, String localName) {
        return this.mAttrCollector.findIndex(nsURI, localName);
    }

    public final QName getCurrentElementName() {
        QName n;
        if (this.mSize == 0) {
            return null;
        }
        String prefix = this.mElements[this.mSize - 4];
        if (prefix == null) {
            prefix = "";
        }
        String nsURI = this.mElements[this.mSize - 2];
        String ln = this.mElements[this.mSize - 3];
        if (ln != this.mLastLocalName) {
            this.mLastLocalName = ln;
            this.mLastPrefix = prefix;
            this.mLastNsURI = nsURI;
        } else if (prefix != this.mLastPrefix) {
            this.mLastPrefix = prefix;
            this.mLastNsURI = nsURI;
        } else if (nsURI != this.mLastNsURI) {
            this.mLastNsURI = nsURI;
        } else {
            return this.mLastName;
        }
        this.mLastName = n = QNameCreator.create(nsURI, ln, prefix);
        return n;
    }

    public int addDefaultAttribute(String localName, String uri, String prefix, String value2) {
        return this.mAttrCollector.addDefaultAttribute(localName, uri, prefix, value2);
    }

    public boolean isPrefixLocallyDeclared(String internedPrefix) {
        if (internedPrefix != null && internedPrefix.length() == 0) {
            internedPrefix = null;
        }
        int len = this.mNamespaces.size();
        for (int offset = this.mNsCounts[this.mSize - 1 >> 2]; offset < len; offset += 2) {
            String thisPrefix = this.mNamespaces.getString(offset);
            if (thisPrefix != internedPrefix) continue;
            return true;
        }
        return false;
    }

    public void addNsBinding(String prefix, String uri) {
        if (uri == null || uri.length() == 0) {
            uri = null;
        }
        if (prefix == null || prefix.length() == 0) {
            prefix = null;
            this.mElements[this.mSize - 1] = uri;
        }
        this.mNamespaces.addStrings(prefix, uri);
    }

    public final boolean isNamespaceAware() {
        return true;
    }

    public final boolean isEmpty() {
        return this.mSize == 0;
    }

    public final int getDepth() {
        return this.mSize >> 2;
    }

    public final String getDefaultNsURI() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 1];
    }

    public final String getNsURI() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 2];
    }

    public final String getPrefix() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 4];
    }

    public final String getLocalName() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 3];
    }

    public final boolean matches(String prefix, String localName) {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        String thisPrefix = this.mElements[this.mSize - 4];
        if (prefix == null || prefix.length() == 0 ? thisPrefix != null && thisPrefix.length() > 0 : thisPrefix != prefix && !thisPrefix.equals(prefix)) {
            return false;
        }
        String thisName = this.mElements[this.mSize - 3];
        return thisName == localName || thisName.equals(localName);
    }

    public final String getTopElementDesc() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        String name = this.mElements[this.mSize - 3];
        String prefix = this.mElements[this.mSize - 4];
        if (prefix == null || prefix.length() == 0) {
            return name;
        }
        return prefix + ":" + name;
    }

    public final int getTotalNsCount() {
        return this.mNamespaces.size() >> 1;
    }

    public final int getCurrentNsCount() {
        return this.mNamespaces.size() - this.mNsCounts[this.mSize - 1 >> 2] >> 1;
    }

    public final String getLocalNsPrefix(int index2) {
        int offset = this.mNsCounts[this.mSize - 1 >> 2];
        int localCount = this.mNamespaces.size() - offset;
        if ((index2 <<= 1) < 0 || index2 >= localCount) {
            this.throwIllegalIndex(index2 >> 1, localCount >> 1);
        }
        return this.mNamespaces.getString(offset + index2);
    }

    public final String getLocalNsURI(int index2) {
        int offset = this.mNsCounts[this.mSize - 1 >> 2];
        int localCount = this.mNamespaces.size() - offset;
        if ((index2 <<= 1) < 0 || index2 >= localCount) {
            this.throwIllegalIndex(index2 >> 1, localCount >> 1);
        }
        return this.mNamespaces.getString(offset + index2 + 1);
    }

    private void throwIllegalIndex(int index2, int localCount) {
        throw new IllegalArgumentException("Illegal namespace index " + (index2 >> 1) + "; current scope only has " + (localCount >> 1) + " namespace declarations.");
    }
}

