/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.compat.QNameCreator;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.ElemAttrs;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.sw.XmlWriter;
import com.ctc.wstx.util.DataUtil;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.TextBuilder;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class NsAttributeCollector
extends AttributeCollector {
    protected static final int ATTR_URI_BUF_SIZE = 16;
    static final int EXP_NS_COUNT = 8;
    private final TextBuilder mNamespaceURIs = new TextBuilder(8);
    private final StringVector mNsPrefixes = new StringVector(8);
    private boolean mDefaultNsDeclared = false;
    private String[] mAttrURIs = null;

    public NsAttributeCollector(ReaderConfig cfg) {
        super(cfg);
    }

    public void reset() {
        this.mNamespaceURIs.reset();
        this.mDefaultNsDeclared = false;
        this.mNsPrefixes.clear(false);
        if (this.mAttrCount > 0) {
            this.mAttrNames.clear(false);
            this.mValueBuffer.reset();
            this.mAttrCount = 0;
            if (this.mXmlIdAttrIndex >= 0) {
                this.mXmlIdAttrIndex = -1;
            }
        }
    }

    public int resolveNamespaces(InputProblemReporter rep2, StringVector ns) throws XMLStreamException {
        int hashCount;
        int i;
        int attrCount;
        this.mNonDefCount = attrCount = this.mAttrCount;
        if (attrCount < 1) {
            this.mAttrSpillEnd = 0;
            this.mAttrHashSize = 0;
            return this.mXmlIdAttrIndex;
        }
        String[] attrURIs = this.mAttrURIs;
        if (attrURIs == null || attrURIs.length < attrCount) {
            int size2 = attrCount < 16 ? 16 : attrCount;
            this.mAttrURIs = attrURIs = new String[size2];
        }
        String[] attrNames = this.mAttrNames.getInternalArray();
        for (i = 0; i < attrCount; ++i) {
            String prefix = attrNames[i + i];
            if (prefix == null) {
                attrURIs[i] = null;
                continue;
            }
            if (prefix == "xml") {
                attrURIs[i] = "http://www.w3.org/XML/1998/namespace";
                continue;
            }
            String uri = ns.findLastFromMap(prefix);
            if (uri == null) {
                rep2.throwParseError(ErrorConsts.ERR_NS_UNDECLARED_FOR_ATTR, prefix, attrNames[i + i + 1]);
            }
            attrURIs[i] = uri;
        }
        if (this.mAttrValues != null) {
            if (this.mAttrValues.length < attrCount) {
                this.mAttrValues = null;
            } else {
                for (i = 0; i < attrCount; ++i) {
                    this.mAttrValues[i] = null;
                }
            }
        }
        int[] map2 = this.mAttrMap;
        int min2 = attrCount + (attrCount >> 2);
        for (hashCount = 4; hashCount < min2; hashCount += hashCount) {
        }
        this.mAttrHashSize = hashCount;
        min2 = hashCount + (hashCount >> 4);
        if (map2 == null || map2.length < min2) {
            map2 = new int[min2];
        } else {
            for (int i2 = 0; i2 < hashCount; ++i2) {
                map2[i2] = 0;
            }
        }
        int mask = hashCount - 1;
        int spillIndex = hashCount;
        for (int i3 = 0; i3 < attrCount; ++i3) {
            int index2;
            String uri = attrURIs[i3];
            String name = attrNames[i3 + i3 + 1];
            int hash = name.hashCode();
            if (uri != null) {
                hash ^= uri.hashCode();
            }
            if (map2[index2 = hash & mask] == 0) {
                map2[index2] = i3 + 1;
                continue;
            }
            int currIndex = map2[index2] - 1;
            if ((map2 = this.spillAttr(uri, name, map2, currIndex, spillIndex, attrCount, hash, hashCount)) == null) {
                this.throwDupAttr(rep2, currIndex);
                continue;
            }
            map2[++spillIndex] = i3;
            ++spillIndex;
        }
        this.mAttrSpillEnd = spillIndex;
        this.mAttrMap = map2;
        return this.mXmlIdAttrIndex;
    }

    protected int getNsCount() {
        return this.mNamespaceURIs.size();
    }

    public boolean hasDefaultNs() {
        return this.mDefaultNsDeclared;
    }

    public String getNsPrefix(int index2) {
        return this.mNsPrefixes.getString(index2);
    }

    public String getNsURI(int index2) {
        return this.mNamespaceURIs.getEntry(index2);
    }

    public String getPrefix(int index2) {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        return this.mAttrNames.getString(index2 << 1);
    }

    public String getLocalName(int index2) {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        return this.mAttrNames.getString((index2 << 1) + 1);
    }

    public String getURI(int index2) {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        return this.mAttrURIs[index2];
    }

    public QName getQName(int index2) {
        String prefix = this.getPrefix(index2);
        if (prefix == null) {
            prefix = "";
        }
        return QNameCreator.create(this.getURI(index2), this.getLocalName(index2), prefix);
    }

    public String getValue(String nsURI, String localName) {
        String thisName;
        int ix;
        boolean hasURI;
        int hashSize = this.mAttrHashSize;
        if (hashSize == 0) {
            return null;
        }
        int hash = localName.hashCode();
        boolean bl = hasURI = nsURI != null && nsURI.length() > 0;
        if (hasURI) {
            hash ^= nsURI.hashCode();
        }
        if ((ix = this.mAttrMap[hash & hashSize - 1]) == 0) {
            return null;
        }
        if ((thisName = this.mAttrNames.getString(--ix + ix + 1)) == localName || thisName.equals(localName)) {
            String thisURI = this.mAttrURIs[ix];
            if (hasURI ? nsURI == thisURI || nsURI.equals(thisURI) : thisURI == null) {
                return this.getValue(ix);
            }
        }
        int len = this.mAttrSpillEnd;
        for (int i = hashSize; i < len; i += 2) {
            if (this.mAttrMap[i] != hash || (thisName = this.mAttrNames.getString((ix = this.mAttrMap[i + 1]) + ix + 1)) != localName && !thisName.equals(localName)) continue;
            String thisURI = this.mAttrURIs[ix];
            if (!(hasURI ? nsURI == thisURI || nsURI.equals(thisURI) : thisURI == null)) continue;
            return this.getValue(ix);
        }
        return null;
    }

    public int findIndex(String nsURI, String localName) {
        String thisName;
        int ix;
        boolean hasURI;
        int hashSize = this.mAttrHashSize;
        if (hashSize == 0) {
            return -1;
        }
        int hash = localName.hashCode();
        boolean bl = hasURI = nsURI != null && nsURI.length() > 0;
        if (hasURI) {
            hash ^= nsURI.hashCode();
        }
        if ((ix = this.mAttrMap[hash & hashSize - 1]) == 0) {
            return -1;
        }
        if ((thisName = this.mAttrNames.getString(--ix + ix + 1)) == localName || thisName.equals(localName)) {
            String thisURI = this.mAttrURIs[ix];
            if (hasURI ? nsURI == thisURI || nsURI.equals(thisURI) : thisURI == null) {
                return ix;
            }
        }
        int len = this.mAttrSpillEnd;
        for (int i = hashSize; i < len; i += 2) {
            if (this.mAttrMap[i] != hash || (thisName = this.mAttrNames.getString((ix = this.mAttrMap[i + 1]) + ix + 1)) != localName && !thisName.equals(localName)) continue;
            String thisURI = this.mAttrURIs[ix];
            if (!(hasURI ? nsURI == thisURI || nsURI.equals(thisURI) : thisURI == null)) continue;
            return ix;
        }
        return -1;
    }

    public TextBuilder getDefaultNsBuilder() {
        if (this.mDefaultNsDeclared) {
            return null;
        }
        this.mDefaultNsDeclared = true;
        this.mNsPrefixes.addString(null);
        return this.mNamespaceURIs;
    }

    public TextBuilder getNsBuilder(String prefix) {
        if (this.mNsPrefixes.containsInterned(prefix)) {
            return null;
        }
        this.mNsPrefixes.addString(prefix);
        return this.mNamespaceURIs;
    }

    public TextBuilder getAttrBuilder(String attrPrefix, String attrLocalName) {
        if (this.mAttrCount == 0) {
            if (this.mValueBuffer == null) {
                this.allocBuffers();
            }
            this.mAttrCount = 1;
        } else {
            ++this.mAttrCount;
        }
        this.mAttrNames.addStrings(attrPrefix, attrLocalName);
        if (attrPrefix == "xml" && attrLocalName == "id" && this.mXmlIdAttrIndex != -2) {
            this.mXmlIdAttrIndex = this.mAttrCount - 1;
        }
        return this.mValueBuffer;
    }

    protected String[] getNsPrefixes() {
        return this.mNsPrefixes.getInternalArray();
    }

    public TextBuilder getNsURIs() {
        return this.mNamespaceURIs;
    }

    protected String[] getAttrURIs() {
        return this.mAttrURIs;
    }

    public ElemAttrs buildAttrOb() {
        int count2 = this.mAttrCount;
        if (count2 == 0) {
            return null;
        }
        String[] raw2 = new String[count2 << 2];
        for (int i = 0; i < count2; ++i) {
            int ix = i << 2;
            raw2[ix] = this.mAttrNames.getString(i + i + 1);
            raw2[ix + 1] = this.mAttrURIs[i];
            raw2[ix + 2] = this.mAttrNames.getString(i + i);
            raw2[ix + 3] = this.getValue(i);
        }
        if (count2 < 4) {
            return new ElemAttrs(raw2, this.mNonDefCount);
        }
        return new ElemAttrs(raw2, this.mNonDefCount, this.mAttrMap, this.mAttrHashSize, this.mAttrSpillEnd);
    }

    public int addDefaultAttribute(String localName, String uri, String prefix, String value2) {
        int index2;
        int[] map2;
        int attrIndex = this.mAttrCount;
        if (attrIndex < 1) {
            this.initHashArea();
        }
        int hash = localName.hashCode();
        if (uri.length() > 0) {
            hash ^= uri.hashCode();
        }
        if ((map2 = this.mAttrMap)[index2 = hash & this.mAttrHashSize - 1] == 0) {
            map2[index2] = attrIndex + 1;
        } else {
            int currIndex = map2[index2] - 1;
            int spillIndex = this.mAttrSpillEnd;
            if ((map2 = this.spillAttr(uri, localName, map2, currIndex, spillIndex, attrIndex, hash, this.mAttrHashSize)) == null) {
                return -1;
            }
            map2[++spillIndex] = attrIndex;
            this.mAttrMap = map2;
            this.mAttrSpillEnd = ++spillIndex;
        }
        this.mAttrNames.addStrings(prefix, localName);
        if (this.mAttrURIs == null) {
            this.mAttrURIs = new String[16];
        } else if (this.mAttrCount >= this.mAttrURIs.length) {
            this.mAttrURIs = DataUtil.growArrayBy(this.mAttrURIs, 8);
        }
        this.mAttrURIs[attrIndex] = uri;
        if (this.mAttrValues == null) {
            this.mAttrValues = new String[attrIndex + 8];
        } else if (attrIndex >= this.mAttrValues.length) {
            this.mAttrValues = DataUtil.growArrayBy(this.mAttrValues, 8);
        }
        this.mAttrValues[attrIndex] = value2;
        return this.mAttrCount++;
    }

    public void writeAttribute(int index2, XmlWriter xw) throws IOException, XMLStreamException {
        int offset = index2 << 1;
        String ln = this.mAttrNames.getString(offset + 1);
        String prefix = this.mAttrNames.getString(offset);
        if (prefix == null || prefix.length() == 0) {
            xw.writeAttribute(ln, this.getValue(index2));
        } else {
            xw.writeAttribute(prefix, ln, this.getValue(index2));
        }
    }

    private int[] spillAttr(String uri, String name, int[] map2, int currIndex, int spillIndex, int attrCount, int hash, int hashCount) {
        String currURI;
        if (this.mAttrNames.getString(currIndex + currIndex + 1) == name && ((currURI = this.mAttrURIs[currIndex]) == uri || currURI != null && currURI.equals(uri))) {
            return null;
        }
        if (spillIndex + 1 >= map2.length) {
            map2 = DataUtil.growArrayBy(map2, 8);
        }
        for (int j = hashCount; j < spillIndex; j += 2) {
            String currURI2;
            if (map2[j] != hash || this.mAttrNames.getString((currIndex = map2[j + 1]) + currIndex + 1) != name || (currURI2 = this.mAttrURIs[currIndex]) != uri && (currURI2 == null || !currURI2.equals(uri))) continue;
            return null;
        }
        map2[spillIndex] = hash;
        return map2;
    }

    private void initHashArea() {
        this.mAttrSpillEnd = 4;
        this.mAttrHashSize = 4;
        if (this.mAttrMap == null || this.mAttrMap.length < this.mAttrHashSize) {
            this.mAttrMap = new int[this.mAttrHashSize + 1];
        }
        this.mAttrMap[3] = 0;
        this.mAttrMap[2] = 0;
        this.mAttrMap[1] = 0;
        this.mAttrMap[0] = 0;
        this.allocBuffers();
    }
}

