/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.sr.NonNsAttributeCollector;
import com.ctc.wstx.sr.NsDefaultProvider;
import com.ctc.wstx.util.BaseNsContext;
import com.ctc.wstx.util.EmptyNamespaceContext;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.TextBuilder;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.validation.XMLValidator;

public final class NonNsInputElementStack
extends InputElementStack {
    static final String INT_ERR_UNEXPECTED_CALL = "Internal error: method should never be called for non-namespace element stack.";
    protected final NonNsAttributeCollector mAttrCollector;
    protected String[] mElements;
    protected int mSize = 0;
    protected String mLastLocalName = null;
    protected QName mLastName = null;

    public NonNsInputElementStack(int initialSize, ReaderConfig cfg) {
        super(cfg);
        if (initialSize < 4) {
            initialSize = 4;
        }
        this.mElements = new String[initialSize];
        this.mAttrCollector = new NonNsAttributeCollector(cfg);
    }

    protected void setAutomaticDTDValidator(XMLValidator validator, NsDefaultProvider nsDefs) {
        this.addValidator(validator);
    }

    public final void push(String prefix, String localName) {
        throw new IllegalStateException(INT_ERR_UNEXPECTED_CALL);
    }

    public final void push(String fullName) {
        if (this.mSize == this.mElements.length) {
            String[] old = this.mElements;
            this.mElements = new String[old.length + 32];
            System.arraycopy(old, 0, this.mElements, 0, old.length);
        }
        this.mElements[this.mSize] = fullName;
        ++this.mSize;
        this.mAttrCollector.reset();
    }

    public boolean pop() throws XMLStreamException {
        if (this.mSize == 0) {
            throw new IllegalStateException("Popping from empty stack.");
        }
        this.mElements[--this.mSize] = null;
        return this.mSize > 0;
    }

    public int resolveAndValidateElement() throws XMLStreamException {
        int xmlidIx;
        NonNsAttributeCollector ac = this.mAttrCollector;
        this.mIdAttrIndex = xmlidIx = ac.resolveValues(this.mReporter);
        if (this.mValidator == null) {
            if (xmlidIx >= 0) {
                this.normalizeXmlIdAttr(ac, xmlidIx);
            }
            return 4;
        }
        this.mValidator.validateElementStart(this.mElements[this.mSize - 1], null, null);
        int attrLen = ac.getCount();
        if (attrLen > 0) {
            StringVector attrNames = ac.getNameList();
            String[] nameData = attrNames.getInternalArray();
            TextBuilder attrBuilder = ac.getAttrBuilder();
            char[] attrCB = attrBuilder.getCharBuffer();
            for (int i = 0; i < attrLen; ++i) {
                String normValue = this.mValidator.validateAttribute(nameData[i], null, null, attrCB, attrBuilder.getOffset(i), attrBuilder.getOffset(i + 1));
                if (normValue == null) continue;
                ac.setNormalizedValue(i, normValue);
            }
        }
        return this.mValidator.validateElementAndAttributes();
    }

    public int validateEndElement() throws XMLStreamException {
        if (this.mValidator == null) {
            return 4;
        }
        int index2 = this.mSize - 1;
        int result2 = this.mValidator.validateElementEnd(this.mElements[index2], null, null);
        if (index2 == 0) {
            this.mValidator.validationCompleted(true);
        }
        return result2;
    }

    public final AttributeCollector getAttrCollector() {
        return this.mAttrCollector;
    }

    public final BaseNsContext createNonTransientNsContext(Location loc) {
        return EmptyNamespaceContext.getInstance();
    }

    public final String getNamespaceURI(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return "";
        }
        return null;
    }

    public final String getPrefix(String nsURI) {
        return null;
    }

    public final Iterator getPrefixes(String nsURI) {
        return EmptyIterator.getInstance();
    }

    public final int getAttributeCount() {
        return this.mAttrCollector.getCount();
    }

    public final int findAttributeIndex(String nsURI, String localName) {
        if (nsURI != null && nsURI.length() > 0) {
            return -1;
        }
        return this.mAttrCollector.findIndex(localName);
    }

    public final QName getCurrentElementName() {
        if (this.mSize == 0) {
            return null;
        }
        String ln = this.mElements[this.mSize - 1];
        if (ln == this.mLastLocalName) {
            return this.mLastName;
        }
        QName n = new QName(ln);
        this.mLastLocalName = ln;
        this.mLastName = n;
        return n;
    }

    public int addDefaultAttribute(String localName, String uri, String prefix, String value2) {
        return this.mAttrCollector.addDefaultAttribute(localName, value2);
    }

    public boolean isPrefixLocallyDeclared(String internedPrefix) {
        return false;
    }

    public void addNsBinding(String prefix, String uri) {
    }

    public final boolean isNamespaceAware() {
        return false;
    }

    public final int getDepth() {
        return this.mSize;
    }

    public final boolean isEmpty() {
        return this.mSize == 0;
    }

    public final String getDefaultNsURI() {
        return null;
    }

    public final String getNsURI() {
        return null;
    }

    public final String getPrefix() {
        return null;
    }

    public final String getLocalName() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 1];
    }

    public final boolean matches(String prefix, String localName) {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        if (prefix != null && prefix.length() > 0) {
            return false;
        }
        String thisName = this.mElements[this.mSize - 1];
        return thisName == localName || thisName.equals(localName);
    }

    public final String getTopElementDesc() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 1];
    }

    public final int getTotalNsCount() {
        return 0;
    }

    public final int getCurrentNsCount() {
        return 0;
    }

    public final String getLocalNsPrefix(int index2) {
        NonNsInputElementStack.throwIllegalIndex(index2);
        return null;
    }

    public final String getLocalNsURI(int index2) {
        NonNsInputElementStack.throwIllegalIndex(index2);
        return null;
    }

    private static void throwIllegalIndex(int index2) {
        throw new IllegalArgumentException("Illegal namespace index " + index2 + "; current scope has no namespace declarations.");
    }
}

