/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.sr.ElemAttrs;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.sw.XmlWriter;
import com.ctc.wstx.util.StringUtil;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.TextBuilder;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;

public abstract class AttributeCollector {
    static final int INT_SPACE = 32;
    protected static final int LONG_ATTR_LIST_LEN = 4;
    protected static final int EXP_ATTR_COUNT = 12;
    protected static final int XMLID_IX_DISABLED = -2;
    protected static final int XMLID_IX_NONE = -1;
    protected int mAttrCount;
    protected int mNonDefCount;
    protected TextBuilder mValueBuffer = null;
    protected StringVector mAttrNames = null;
    protected int mXmlIdAttrIndex;
    protected String[] mAttrValues = null;
    protected int[] mAttrMap = null;
    protected int mAttrHashSize;
    protected int mAttrSpillEnd;

    protected AttributeCollector(ReaderConfig cfg) {
        this.mXmlIdAttrIndex = cfg.willDoXmlIdTyping() ? -1 : -2;
    }

    protected abstract void reset();

    protected abstract int getNsCount();

    public abstract String getNsPrefix(int var1);

    public abstract String getNsURI(int var1);

    public final int getCount() {
        return this.mAttrCount;
    }

    public int getSpecifiedCount() {
        return this.mNonDefCount;
    }

    public abstract String getPrefix(int var1);

    public abstract String getLocalName(int var1);

    public abstract String getURI(int var1);

    public abstract QName getQName(int var1);

    public final String getValue(int index2) {
        String str;
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        if (this.mAttrValues == null) {
            this.mAttrValues = new String[this.mAttrCount];
        }
        if ((str = this.mAttrValues[index2]) == null) {
            this.mAttrValues[index2] = str = this.mValueBuffer.getEntry(index2);
        }
        return str;
    }

    public abstract String getValue(String var1, String var2);

    public final boolean isSpecified(int index2) {
        return index2 < this.mNonDefCount;
    }

    public final int getXmlIdAttrIndex() {
        return this.mXmlIdAttrIndex;
    }

    public final void decodeValue(int index2, TypedValueDecoder tvd) throws IllegalArgumentException {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        char[] buf = this.mValueBuffer.getCharBuffer();
        int start = this.mValueBuffer.getOffset(index2);
        int end = this.mValueBuffer.getOffset(index2 + 1);
        while (true) {
            if (start >= end) {
                tvd.handleEmptyValue();
                return;
            }
            if (!StringUtil.isSpace(buf[start])) break;
            ++start;
        }
        while (--end > start && StringUtil.isSpace(buf[end])) {
        }
        tvd.decode(buf, start, end + 1);
    }

    public final int decodeValues(int index2, TypedArrayDecoder tad, InputProblemReporter rep2) throws XMLStreamException {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        return AttributeCollector.decodeValues(tad, rep2, this.mValueBuffer.getCharBuffer(), this.mValueBuffer.getOffset(index2), this.mValueBuffer.getOffset(index2 + 1));
    }

    public final byte[] decodeBinary(int index2, Base64Variant v, CharArrayBase64Decoder dec, InputProblemReporter rep2) throws XMLStreamException {
        if (index2 < 0 || index2 >= this.mAttrCount) {
            this.throwIndex(index2);
        }
        char[] cbuf = this.mValueBuffer.getCharBuffer();
        int offset = this.mValueBuffer.getOffset(index2);
        int len = this.mValueBuffer.getOffset(index2 + 1) - offset;
        dec.init(v, true, cbuf, offset, len, null);
        try {
            return dec.decodeCompletely();
        }
        catch (IllegalArgumentException iae) {
            String lexical = new String(cbuf, offset, len);
            throw new TypedXMLStreamException(lexical, iae.getMessage(), rep2.getLocation(), iae);
        }
    }

    private static final int decodeValues(TypedArrayDecoder tad, InputProblemReporter rep2, char[] buf, int ptr, int end) throws XMLStreamException {
        int count2;
        block5: {
            int start = ptr;
            count2 = 0;
            try {
                while (ptr < end) {
                    while (buf[ptr] <= ' ') {
                        if (++ptr < end) continue;
                        break block5;
                    }
                    start = ptr++;
                    while (ptr < end && buf[ptr] > ' ') {
                        ++ptr;
                    }
                    int tokenEnd = ptr++;
                    ++count2;
                    if (!tad.decodeValue(buf, start, tokenEnd) || AttributeCollector.checkExpand(tad)) continue;
                    break;
                }
            }
            catch (IllegalArgumentException iae) {
                Location loc = rep2.getLocation();
                String lexical = new String(buf, start, ptr - start);
                throw new TypedXMLStreamException(lexical, iae.getMessage(), loc, iae);
            }
        }
        return count2;
    }

    private static final boolean checkExpand(TypedArrayDecoder tad) {
        if (tad instanceof ValueDecoderFactory.BaseArrayDecoder) {
            ((ValueDecoderFactory.BaseArrayDecoder)tad).expand();
            return true;
        }
        return false;
    }

    public abstract TextBuilder getDefaultNsBuilder();

    public abstract TextBuilder getNsBuilder(String var1);

    public abstract TextBuilder getAttrBuilder(String var1, String var2);

    public abstract ElemAttrs buildAttrOb();

    public final TextBuilder getAttrBuilder() {
        return this.mValueBuffer;
    }

    public final void setNormalizedValue(int index2, String value2) {
        if (this.mAttrValues == null) {
            this.mAttrValues = new String[this.mAttrCount];
        }
        this.mAttrValues[index2] = value2;
    }

    protected void throwIndex(int index2) {
        throw new IllegalArgumentException("Invalid index " + index2 + "; current element has only " + this.getCount() + " attributes");
    }

    public final StringVector getNameList() {
        return this.mAttrNames;
    }

    public abstract void writeAttribute(int var1, XmlWriter var2) throws IOException, XMLStreamException;

    protected final void allocBuffers() {
        if (this.mValueBuffer == null) {
            this.mValueBuffer = new TextBuilder(12);
        }
        if (this.mAttrNames == null) {
            this.mAttrNames = new StringVector(12);
        }
    }

    protected static String[] resize(String[] old) {
        int len = old.length;
        String[] result2 = new String[len];
        System.arraycopy(old, 0, result2, 0, len);
        return result2;
    }

    protected void throwDupAttr(InputProblemReporter rep2, int index2) throws XMLStreamException {
        rep2.throwParseError("Duplicate attribute '" + this.getQName(index2) + "'.");
    }
}

