/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.api;

import com.ctc.wstx.util.DataUtil;
import java.util.HashMap;
import org.codehaus.stax2.XMLStreamProperties;

abstract class CommonConfig
implements XMLStreamProperties {
    protected static final String IMPL_NAME = "woodstox";
    protected static final String IMPL_VERSION = "4.0";
    static final int PROP_IMPL_NAME = 1;
    static final int PROP_IMPL_VERSION = 2;
    static final int PROP_SUPPORTS_XML11 = 3;
    static final int PROP_SUPPORT_XMLID = 4;
    static final HashMap sStdProperties = new HashMap(16);

    protected CommonConfig() {
    }

    public final Object getProperty(String propName) {
        int id = this.findPropertyId(propName);
        if (id >= 0) {
            return this.getProperty(id);
        }
        id = this.findStdPropertyId(propName);
        if (id < 0) {
            throw new IllegalArgumentException("Unrecognized property '" + propName + "'");
        }
        return this.getStdProperty(id);
    }

    public final boolean isPropertySupported(String propName) {
        return this.findPropertyId(propName) >= 0 || this.findStdPropertyId(propName) >= 0;
    }

    public final boolean setProperty(String propName, Object value2) {
        int id = this.findPropertyId(propName);
        if (id >= 0) {
            return this.setProperty(propName, id, value2);
        }
        id = this.findStdPropertyId(propName);
        if (id < 0) {
            throw new IllegalArgumentException("Unrecognized property '" + propName + "'");
        }
        return this.setStdProperty(propName, id, value2);
    }

    public final Object safeGetProperty(String propName) {
        int id = this.findPropertyId(propName);
        if (id >= 0) {
            return this.getProperty(id);
        }
        id = this.findStdPropertyId(propName);
        if (id < 0) {
            return null;
        }
        return this.getStdProperty(id);
    }

    public static String getImplName() {
        return IMPL_NAME;
    }

    public static String getImplVersion() {
        return IMPL_VERSION;
    }

    protected abstract int findPropertyId(String var1);

    protected boolean doesSupportXml11() {
        return true;
    }

    protected boolean doesSupportXmlId() {
        return true;
    }

    protected abstract Object getProperty(int var1);

    protected abstract boolean setProperty(String var1, int var2, Object var3);

    protected int findStdPropertyId(String propName) {
        Integer I = (Integer)sStdProperties.get(propName);
        return I == null ? -1 : I;
    }

    protected boolean setStdProperty(String propName, int id, Object value2) {
        return false;
    }

    protected Object getStdProperty(int id) {
        switch (id) {
            case 1: {
                return IMPL_NAME;
            }
            case 2: {
                return IMPL_VERSION;
            }
            case 3: {
                return this.doesSupportXml11() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.doesSupportXmlId() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw new IllegalStateException("Internal error: no handler for property with internal id " + id + ".");
    }

    static {
        sStdProperties.put("org.codehaus.stax2.implName", DataUtil.Integer(1));
        sStdProperties.put("org.codehaus.stax2.implVersion", DataUtil.Integer(2));
        sStdProperties.put("org.codehaus.stax2.supportsXml11", DataUtil.Integer(3));
        sStdProperties.put("org.codehaus.stax2.supportXmlId", DataUtil.Integer(4));
        sStdProperties.put("http://java.sun.com/xml/stream/properties/implementation-name", DataUtil.Integer(1));
    }
}

