/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.normalization.bolts;

import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.normalization.Normalizer;
import eu.europeana.normalization.NormalizerFactory;
import eu.europeana.normalization.model.NormalizationResult;
import eu.europeana.normalization.util.NormalizationConfigurationException;
import eu.europeana.normalization.util.NormalizationException;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizationBolt
extends AbstractDpsBolt {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalizationBolt.class);
    private static final String NORMALIZATION_EX_MESSAGE = "Unable to normalize file";
    private transient NormalizerFactory normalizerFactory;

    public void prepare() {
        this.normalizerFactory = new NormalizerFactory();
    }

    public void execute(StormTaskTuple stormTaskTuple) {
        try {
            Normalizer normalizer = this.normalizerFactory.getNormalizer();
            String document = new String(stormTaskTuple.getFileData());
            NormalizationResult normalizationResult = normalizer.normalize(document);
            if (normalizationResult.getErrorMessage() != null) {
                LOGGER.error(NORMALIZATION_EX_MESSAGE, (Object)normalizationResult.getErrorMessage());
                this.emitErrorNotification(stormTaskTuple.getTaskId(), stormTaskTuple.getFileUrl(), normalizationResult.getErrorMessage(), "Error during normalization.");
            } else {
                String output = normalizationResult.getNormalizedRecordInEdmXml();
                this.emitNormalizedContent(stormTaskTuple, output);
            }
        }
        catch (NormalizationConfigurationException e) {
            LOGGER.error(NORMALIZATION_EX_MESSAGE, (Throwable)e);
            this.emitErrorNotification(stormTaskTuple.getTaskId(), stormTaskTuple.getFileUrl(), e.getMessage(), "Error in normalizer configuration. The full error is: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NormalizationException e) {
            LOGGER.error(NORMALIZATION_EX_MESSAGE, (Throwable)e);
            this.emitErrorNotification(stormTaskTuple.getTaskId(), stormTaskTuple.getFileUrl(), e.getMessage(), "Error during normalization. The full error is: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (MalformedURLException e) {
            LOGGER.error(NORMALIZATION_EX_MESSAGE, (Throwable)e);
            this.emitErrorNotification(stormTaskTuple.getTaskId(), stormTaskTuple.getFileUrl(), e.getMessage(), "Cannot prepare output storm tuple. The full error is: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void emitNormalizedContent(StormTaskTuple stormTaskTuple, String output) throws MalformedURLException {
        this.prepareStormTaskTupleForEmission(stormTaskTuple, output);
        this.outputCollector.emit((List)stormTaskTuple.toStormTuple());
    }
}

