/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.ServletContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextAttributeExporter
implements ServletContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, Object> attributes;

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        for (Map.Entry<String, Object> entry2 : this.attributes.entrySet()) {
            String attributeName = entry2.getKey();
            if (this.logger.isWarnEnabled() && servletContext.getAttribute(attributeName) != null) {
                this.logger.warn((Object)("Replacing existing ServletContext attribute with name '" + attributeName + "'"));
            }
            servletContext.setAttribute(attributeName, entry2.getValue());
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Exported ServletContext attribute with name '" + attributeName + "'"));
        }
    }
}

