/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;

public abstract class ValidationUtils {
    private static Log logger = LogFactory.getLog(ValidationUtils.class);

    public static void invokeValidator(Validator validator, Object obj, Errors errors) {
        ValidationUtils.invokeValidator(validator, obj, errors, null);
    }

    public static void invokeValidator(Validator validator, Object obj, Errors errors, Object ... validationHints) {
        Assert.notNull(validator, "Validator must not be null");
        Assert.notNull(errors, "Errors object must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invoking validator [" + validator + "]"));
        }
        if (obj != null && !validator.supports(obj.getClass())) {
            throw new IllegalArgumentException("Validator [" + validator.getClass() + "] does not support [" + obj.getClass() + "]");
        }
        if (!ObjectUtils.isEmpty(validationHints) && validator instanceof SmartValidator) {
            ((SmartValidator)validator).validate(obj, errors, validationHints);
        } else {
            validator.validate(obj, errors);
        }
        if (logger.isDebugEnabled()) {
            if (errors.hasErrors()) {
                logger.debug((Object)("Validator found " + errors.getErrorCount() + " errors"));
            } else {
                logger.debug((Object)"Validator found no errors");
            }
        }
    }

    public static void rejectIfEmpty(Errors errors, String field2, String errorCode) {
        ValidationUtils.rejectIfEmpty(errors, field2, errorCode, null, null);
    }

    public static void rejectIfEmpty(Errors errors, String field2, String errorCode, String defaultMessage) {
        ValidationUtils.rejectIfEmpty(errors, field2, errorCode, null, defaultMessage);
    }

    public static void rejectIfEmpty(Errors errors, String field2, String errorCode, Object[] errorArgs) {
        ValidationUtils.rejectIfEmpty(errors, field2, errorCode, errorArgs, null);
    }

    public static void rejectIfEmpty(Errors errors, String field2, String errorCode, Object[] errorArgs, String defaultMessage) {
        Assert.notNull(errors, "Errors object must not be null");
        Object value2 = errors.getFieldValue(field2);
        if (value2 == null || !StringUtils.hasLength(value2.toString())) {
            errors.rejectValue(field2, errorCode, errorArgs, defaultMessage);
        }
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field2, String errorCode) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field2, errorCode, null, null);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field2, String errorCode, String defaultMessage) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field2, errorCode, null, defaultMessage);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field2, String errorCode, Object[] errorArgs) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field2, errorCode, errorArgs, null);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field2, String errorCode, Object[] errorArgs, String defaultMessage) {
        Assert.notNull(errors, "Errors object must not be null");
        Object value2 = errors.getFieldValue(field2);
        if (value2 == null || !StringUtils.hasText(value2.toString())) {
            errors.rejectValue(field2, errorCode, errorArgs, defaultMessage);
        }
    }
}

