/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.IOException;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public abstract class FileSystemUtils {
    public static boolean deleteRecursively(File root2) {
        if (root2 != null && root2.exists()) {
            File[] children;
            if (root2.isDirectory() && (children = root2.listFiles()) != null) {
                for (File child : children) {
                    FileSystemUtils.deleteRecursively(child);
                }
            }
            return root2.delete();
        }
        return false;
    }

    public static void copyRecursively(File src, File dest) throws IOException {
        Assert.isTrue(src != null && (src.isDirectory() || src.isFile()), "Source File must denote a directory or file");
        Assert.notNull(dest, "Destination File must not be null");
        FileSystemUtils.doCopyRecursively(src, dest);
    }

    private static void doCopyRecursively(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            dest.mkdir();
            File[] entries = src.listFiles();
            if (entries == null) {
                throw new IOException("Could not list files in directory: " + src);
            }
            for (File entry2 : entries) {
                FileSystemUtils.doCopyRecursively(entry2, new File(dest, entry2.getName()));
            }
        } else if (src.isFile()) {
            try {
                dest.createNewFile();
            }
            catch (IOException ex) {
                IOException ioex = new IOException("Failed to create file: " + dest);
                ioex.initCause(ex);
                throw ioex;
            }
            FileCopyUtils.copy(src, dest);
        }
    }
}

