/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.JtaTransactionObject;
import org.springframework.transaction.jta.ManagedTransactionAdapter;
import org.springframework.util.ClassUtils;

@Deprecated
public class OC4JJtaTransactionManager
extends JtaTransactionManager {
    private static final String TRANSACTION_UTILITY_CLASS_NAME = "oracle.j2ee.transaction.TransactionUtility";
    private static final String TRANSACTION_MANAGER_CLASS_NAME = "oracle.j2ee.transaction.OC4JTransactionManager";
    private static final String TRANSACTION_CLASS_NAME = "oracle.j2ee.transaction.OC4JTransaction";
    private static final String FALLBACK_TRANSACTION_MANAGER_CLASS_NAME = "com.evermind.server.ApplicationServerTransactionManager";
    private static final String FALLBACK_TRANSACTION_CLASS_NAME = "com.evermind.server.ApplicationServerTransaction";
    private Method beginWithNameMethod;
    private Method setTransactionIsolationMethod;

    public void afterPropertiesSet() throws TransactionSystemException {
        super.afterPropertiesSet();
        this.loadOC4JTransactionClasses();
    }

    protected UserTransaction retrieveUserTransaction() throws TransactionSystemException {
        try {
            Class<?> transactionUtilityClass = this.getClass().getClassLoader().loadClass(TRANSACTION_UTILITY_CLASS_NAME);
            Method getInstanceMethod = transactionUtilityClass.getMethod("getInstance", new Class[0]);
            Object transactionUtility = getInstanceMethod.invoke(null, new Object[0]);
            this.logger.debug((Object)"Retrieving JTA UserTransaction from OC4J TransactionUtility");
            Method getUserTransactionMethod = transactionUtility.getClass().getMethod("getOC4JUserTransaction", new Class[0]);
            return (UserTransaction)getUserTransactionMethod.invoke(transactionUtility, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            this.logger.debug((Object)("Could not find OC4J 10.1.3.2 TransactionUtility: " + ex));
            return null;
        }
        catch (InvocationTargetException ex) {
            throw new TransactionSystemException("OC4J's TransactionUtility.getOC4JUserTransaction() method failed", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not invoke OC4J's TransactionUtility.getOC4JUserTransaction() method", ex);
        }
    }

    private void loadOC4JTransactionClasses() throws TransactionSystemException {
        Class<?> transactionManagerClass = null;
        Class<?> transactionClass = null;
        try {
            transactionManagerClass = this.getClass().getClassLoader().loadClass(TRANSACTION_MANAGER_CLASS_NAME);
            transactionClass = this.getClass().getClassLoader().loadClass(TRANSACTION_CLASS_NAME);
        }
        catch (ClassNotFoundException ex) {
            try {
                transactionManagerClass = this.getClass().getClassLoader().loadClass(FALLBACK_TRANSACTION_MANAGER_CLASS_NAME);
                transactionClass = this.getClass().getClassLoader().loadClass(FALLBACK_TRANSACTION_CLASS_NAME);
            }
            catch (ClassNotFoundException ex2) {
                throw new TransactionSystemException("Could not initialize OC4JJtaTransactionManager because OC4J API classes are not available", ex);
            }
        }
        if (transactionManagerClass.isInstance(this.getUserTransaction())) {
            this.beginWithNameMethod = ClassUtils.getMethodIfAvailable(transactionManagerClass, "begin", String.class);
            this.setTransactionIsolationMethod = ClassUtils.getMethodIfAvailable(transactionClass, "setTransactionIsolation", Integer.TYPE);
            this.logger.info((Object)"Support for OC4J transaction names and isolation levels available");
        } else {
            this.logger.info((Object)"Support for OC4J transaction names and isolation levels not available");
        }
    }

    protected void doJtaBegin(JtaTransactionObject txObject, TransactionDefinition definition) throws NotSupportedException, SystemException {
        int timeout = this.determineTimeout(definition);
        this.applyTimeout(txObject, timeout);
        if (this.beginWithNameMethod != null && definition.getName() != null) {
            try {
                this.beginWithNameMethod.invoke((Object)txObject.getUserTransaction(), definition.getName());
            }
            catch (InvocationTargetException ex) {
                throw new TransactionSystemException("OC4J's UserTransaction.begin(String) method failed", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new TransactionSystemException("Could not invoke OC4J's UserTransaction.begin(String) method", ex);
            }
        } else {
            txObject.getUserTransaction().begin();
        }
        if (this.setTransactionIsolationMethod != null) {
            if (definition.getIsolationLevel() != -1) {
                try {
                    Transaction tx = this.getTransactionManager().getTransaction();
                    this.setTransactionIsolationMethod.invoke((Object)tx, definition.getIsolationLevel());
                }
                catch (InvocationTargetException ex) {
                    throw new TransactionSystemException("OC4J's Transaction.setTransactionIsolation(int) method failed", ex.getTargetException());
                }
                catch (Exception ex) {
                    throw new TransactionSystemException("Could not invoke OC4J's Transaction.setTransactionIsolation(int) method", ex);
                }
            }
        } else {
            this.applyIsolationLevel(txObject, definition.getIsolationLevel());
        }
    }

    public Transaction createTransaction(String name, int timeout) throws NotSupportedException, SystemException {
        if (this.beginWithNameMethod != null && name != null) {
            UserTransaction ut = this.getUserTransaction();
            if (timeout >= 0) {
                ut.setTransactionTimeout(timeout);
            }
            try {
                this.beginWithNameMethod.invoke((Object)ut, name);
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof NotSupportedException) {
                    throw (NotSupportedException)ex.getTargetException();
                }
                if (ex.getTargetException() instanceof SystemException) {
                    throw (SystemException)ex.getTargetException();
                }
                if (ex.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getTargetException();
                }
                throw new SystemException("OC4J's begin(String) method failed with an unexpected error: " + ex.getTargetException());
            }
            catch (Exception ex) {
                throw new SystemException("Could not invoke OC4J's UserTransaction.begin(String) method: " + ex);
            }
            return new ManagedTransactionAdapter(this.getTransactionManager());
        }
        return super.createTransaction(name, timeout);
    }
}

