/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.format.Formatter;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatter
implements Formatter<Date> {
    private static final Map<DateTimeFormat.ISO, String> ISO_PATTERNS;
    private String pattern;
    private int style = 2;
    private String stylePattern;
    private DateTimeFormat.ISO iso;
    private TimeZone timeZone;
    private boolean lenient = false;

    public DateFormatter() {
    }

    public DateFormatter(String pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setIso(DateTimeFormat.ISO iso) {
        this.iso = iso;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setStylePattern(String stylePattern) {
        this.stylePattern = stylePattern;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public String print(Date date, Locale locale) {
        return this.getDateFormat(locale).format(date);
    }

    @Override
    public Date parse(String text2, Locale locale) throws ParseException {
        return this.getDateFormat(locale).parse(text2);
    }

    protected DateFormat getDateFormat(Locale locale) {
        DateFormat dateFormat = this.createDateFormat(locale);
        if (this.timeZone != null) {
            dateFormat.setTimeZone(this.timeZone);
        }
        dateFormat.setLenient(this.lenient);
        return dateFormat;
    }

    private DateFormat createDateFormat(Locale locale) {
        if (StringUtils.hasLength(this.pattern)) {
            return new SimpleDateFormat(this.pattern, locale);
        }
        if (this.iso != null && this.iso != DateTimeFormat.ISO.NONE) {
            String pattern = ISO_PATTERNS.get((Object)this.iso);
            Assert.state(pattern != null, "Unsupported ISO format " + (Object)((Object)this.iso));
            SimpleDateFormat format2 = new SimpleDateFormat(pattern);
            format2.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format2;
        }
        if (StringUtils.hasLength(this.stylePattern)) {
            int dateStyle = this.getStylePatternForChar(0);
            int timeStyle = this.getStylePatternForChar(1);
            if (dateStyle != -1 && timeStyle != -1) {
                return DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
            }
            if (dateStyle != -1) {
                return DateFormat.getDateInstance(dateStyle, locale);
            }
            if (timeStyle != -1) {
                return DateFormat.getTimeInstance(timeStyle, locale);
            }
            throw new IllegalStateException("Unsupported style pattern '" + this.stylePattern + "'");
        }
        return DateFormat.getDateInstance(this.style, locale);
    }

    private int getStylePatternForChar(int index2) {
        if (this.stylePattern != null && this.stylePattern.length() > index2) {
            switch (this.stylePattern.charAt(index2)) {
                case 'S': {
                    return 3;
                }
                case 'M': {
                    return 2;
                }
                case 'L': {
                    return 1;
                }
                case 'F': {
                    return 0;
                }
                case '-': {
                    return -1;
                }
            }
        }
        throw new IllegalStateException("Unsupported style pattern '" + this.stylePattern + "'");
    }

    static {
        HashMap<DateTimeFormat.ISO, String> formats = new HashMap<DateTimeFormat.ISO, String>(4);
        formats.put(DateTimeFormat.ISO.DATE, "yyyy-MM-dd");
        formats.put(DateTimeFormat.ISO.TIME, "HH:mm:ss.SSSZ");
        formats.put(DateTimeFormat.ISO.DATE_TIME, "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        ISO_PATTERNS = Collections.unmodifiableMap(formats);
    }
}

