/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.glassfish.json.JsonMessages;
import org.glassfish.json.JsonNumberImpl;
import org.glassfish.json.JsonStringImpl;
import org.glassfish.json.JsonWriterImpl;
import org.glassfish.json.api.BufferPool;

class JsonArrayBuilderImpl
implements JsonArrayBuilder {
    private ArrayList<JsonValue> valueList;
    private final BufferPool bufferPool;

    JsonArrayBuilderImpl(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonArrayBuilder add(JsonValue value2) {
        this.validateValue(value2);
        this.addValueList(value2);
        return this;
    }

    @Override
    public JsonArrayBuilder add(String value2) {
        this.validateValue(value2);
        this.addValueList(new JsonStringImpl(value2));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigDecimal value2) {
        this.validateValue(value2);
        this.addValueList(JsonNumberImpl.getJsonNumber(value2));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigInteger value2) {
        this.validateValue(value2);
        this.addValueList(JsonNumberImpl.getJsonNumber(value2));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int value2) {
        this.addValueList(JsonNumberImpl.getJsonNumber(value2));
        return this;
    }

    @Override
    public JsonArrayBuilder add(long value2) {
        this.addValueList(JsonNumberImpl.getJsonNumber(value2));
        return this;
    }

    @Override
    public JsonArrayBuilder add(double value2) {
        this.addValueList(JsonNumberImpl.getJsonNumber(value2));
        return this;
    }

    @Override
    public JsonArrayBuilder add(boolean value2) {
        this.addValueList(value2 ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonArrayBuilder addNull() {
        this.addValueList(JsonValue.NULL);
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_OBJECT_BUILDER_NULL());
        }
        this.addValueList(builder.build());
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_ARRAY_BUILDER_NULL());
        }
        this.addValueList(builder.build());
        return this;
    }

    @Override
    public JsonArray build() {
        List<Object> snapshot = this.valueList == null ? Collections.emptyList() : Collections.unmodifiableList(this.valueList);
        this.valueList = null;
        return new JsonArrayImpl(snapshot, this.bufferPool);
    }

    private void addValueList(JsonValue value2) {
        if (this.valueList == null) {
            this.valueList = new ArrayList();
        }
        this.valueList.add(value2);
    }

    private void validateValue(Object value2) {
        if (value2 == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_VALUE_NULL());
        }
    }

    private static final class JsonArrayImpl
    extends AbstractList<JsonValue>
    implements JsonArray {
        private final List<JsonValue> valueList;
        private final BufferPool bufferPool;

        JsonArrayImpl(List<JsonValue> valueList, BufferPool bufferPool) {
            this.valueList = valueList;
            this.bufferPool = bufferPool;
        }

        @Override
        public int size() {
            return this.valueList.size();
        }

        @Override
        public JsonObject getJsonObject(int index2) {
            return (JsonObject)this.valueList.get(index2);
        }

        @Override
        public JsonArray getJsonArray(int index2) {
            return (JsonArray)this.valueList.get(index2);
        }

        @Override
        public JsonNumber getJsonNumber(int index2) {
            return (JsonNumber)this.valueList.get(index2);
        }

        @Override
        public JsonString getJsonString(int index2) {
            return (JsonString)this.valueList.get(index2);
        }

        @Override
        public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
            return this.valueList;
        }

        @Override
        public String getString(int index2) {
            return this.getJsonString(index2).getString();
        }

        @Override
        public String getString(int index2, String defaultValue) {
            try {
                return this.getString(index2);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        @Override
        public int getInt(int index2) {
            return this.getJsonNumber(index2).intValue();
        }

        @Override
        public int getInt(int index2, int defaultValue) {
            try {
                return this.getInt(index2);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        @Override
        public boolean getBoolean(int index2) {
            JsonValue jsonValue = this.get(index2);
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        @Override
        public boolean getBoolean(int index2, boolean defaultValue) {
            try {
                return this.getBoolean(index2);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        @Override
        public boolean isNull(int index2) {
            return this.valueList.get(index2).equals(JsonValue.NULL);
        }

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.ARRAY;
        }

        @Override
        public JsonValue get(int index2) {
            return this.valueList.get(index2);
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            JsonWriterImpl jw = new JsonWriterImpl(sw, this.bufferPool);
            jw.write(this);
            jw.close();
            return sw.toString();
        }
    }
}

