/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.filtering;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.jersey.internal.util.Tokenizer;
import org.glassfish.jersey.message.filtering.spi.ScopeResolver;

@Singleton
public class SelectableScopeResolver
implements ScopeResolver {
    public static final String PREFIX = SelectableScopeResolver.class.getName() + "_";
    public static final String DEFAULT_SCOPE = PREFIX + "*";
    private static String SELECTABLE_PARAM_NAME = "select";
    @Context
    private Configuration configuration;
    @Context
    private UriInfo uriInfo;

    @PostConstruct
    private void init() {
        String paramName = (String)this.configuration.getProperty("jersey.config.entityFiltering.selectable.query");
        SELECTABLE_PARAM_NAME = paramName != null ? paramName : SELECTABLE_PARAM_NAME;
    }

    @Override
    public Set<String> resolve(Annotation[] annotations) {
        HashSet<String> scopes = new HashSet<String>();
        List fields = (List)this.uriInfo.getQueryParameters().get(SELECTABLE_PARAM_NAME);
        if (fields != null && !fields.isEmpty()) {
            for (String field2 : fields) {
                scopes.addAll(this.getScopesForField(field2));
            }
        } else {
            scopes.add(DEFAULT_SCOPE);
        }
        return scopes;
    }

    private Set<String> getScopesForField(String fieldName) {
        String[] fields;
        HashSet<String> scopes = Sets.newHashSet();
        for (String field2 : fields = Tokenizer.tokenize(fieldName, ",")) {
            String[] subfields = Tokenizer.tokenize(field2, ".");
            scopes.add(PREFIX + subfields[0]);
            if (subfields.length <= 1) continue;
            scopes.add(PREFIX + field2);
        }
        return scopes;
    }
}

