/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import java.io.StringWriter;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.QuerySequence;

public class UnaryTableSequence
extends QuerySequence {
    protected String counterFieldName = "SEQUENCE";
    protected String updateString1;
    protected String updateString2;
    protected String selectString1;
    protected String selectString2;
    protected int updateStringBufferSize;
    protected int selectStringBufferSize;

    public UnaryTableSequence() {
        super(false, true);
    }

    public UnaryTableSequence(String name) {
        super(name, false, true);
    }

    public UnaryTableSequence(String name, int size2) {
        super(name, size2, false, true);
    }

    public UnaryTableSequence(String name, String counterFieldName) {
        this(name);
        this.setCounterFieldName(counterFieldName);
    }

    public UnaryTableSequence(String name, int size2, String counterFieldName) {
        this(name, size2);
        this.setCounterFieldName(counterFieldName);
    }

    @Override
    public boolean isUnaryTable() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UnaryTableSequence) {
            UnaryTableSequence other = (UnaryTableSequence)obj;
            if (UnaryTableSequence.equalNameAndSize(this, other)) {
                return this.getCounterFieldName().equals(other.getCounterFieldName());
            }
            return false;
        }
        return false;
    }

    public void setCounterFieldName(String name) {
        this.counterFieldName = name;
    }

    public String getCounterFieldName() {
        return this.counterFieldName;
    }

    @Override
    public void onConnect() {
        super.onConnect();
        this.initialize();
    }

    @Override
    public void onDisconnect() {
        this.clear();
        super.onDisconnect();
    }

    @Override
    protected ValueReadQuery buildSelectQuery(String seqName, Integer size2) {
        ValueReadQuery selectQuery = new ValueReadQuery();
        selectQuery.dontBindAllParameters();
        StringWriter writer = new StringWriter(this.selectStringBufferSize + seqName.length());
        writer.write(this.selectString1);
        writer.write(seqName);
        selectQuery.setSQLString(writer.toString());
        return selectQuery;
    }

    @Override
    protected DataModifyQuery buildUpdateQuery(String seqName, Number size2) {
        DataModifyQuery updateQuery = new DataModifyQuery();
        updateQuery.dontBindAllParameters();
        String sizeString = size2.toString();
        StringWriter writer = new StringWriter(this.updateStringBufferSize + seqName.length() + sizeString.length());
        writer.write(this.updateString1);
        writer.write(seqName);
        writer.write(this.updateString2);
        writer.write(sizeString);
        updateQuery.setSQLString(writer.toString());
        return updateQuery;
    }

    protected void initialize() {
        if (this.getSelectQuery() == null) {
            this.buildSelectString1();
            this.selectStringBufferSize = this.selectString1.length();
        }
        if (this.getUpdateQuery() == null && !this.shouldSkipUpdate()) {
            this.buildUpdateString1();
            this.buildUpdateString2();
            this.updateStringBufferSize = this.updateString1.length() + this.updateString2.length();
        }
    }

    protected void buildUpdateString1() {
        this.updateString1 = "UPDATE ";
        if (this.qualifier != "") {
            this.updateString1 = String.valueOf(this.updateString1) + this.qualifier + '.';
        }
    }

    protected void buildUpdateString2() {
        StringWriter writer = new StringWriter();
        writer.write(" SET ");
        writer.write(this.getCounterFieldName());
        writer.write(" = ");
        writer.write(this.getCounterFieldName());
        writer.write(" + ");
        this.updateString2 = writer.toString();
    }

    protected void buildSelectString1() {
        this.selectString1 = "SELECT * FROM ";
        if (this.qualifier != "") {
            this.selectString1 = String.valueOf(this.selectString1) + this.qualifier + '.';
        }
    }

    protected void clear() {
        this.updateString1 = null;
        this.updateString2 = null;
        this.selectString1 = null;
        this.selectString2 = null;
        this.updateStringBufferSize = 0;
        this.selectStringBufferSize = 0;
    }
}

