/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.jdbc;

import java.sql.Array;
import java.sql.Struct;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.jdbc.JDBCType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

public enum JDBCTypes implements JDBCType
{
    ARRAY_TYPE(2003, "ARRAY"),
    BIGINT_TYPE(-5, "BIGINT"),
    BINARY_TYPE(-2, "BINARY"),
    BIT_TYPE(-7, "BIT"),
    BLOB_TYPE(2004, "BLOB"),
    BOOLEAN_TYPE(16, "BOOLEAN"),
    CHAR_TYPE(1, "CHAR"),
    NCHAR_TYPE(-15, "NCHAR"),
    CLOB_TYPE(2005, "CLOB"),
    DATALINK_TYPE(70, "DATALINK"),
    DATE_TYPE(91, "DATE"),
    DECIMAL_TYPE(3, "DECIMAL"),
    DISTINCT_TYPE(2001, "DISTINCT"),
    DOUBLE_TYPE(8, "DOUBLE"),
    FLOAT_TYPE(6, "FLOAT"),
    INTEGER_TYPE(4, "INTEGER"),
    JAVA_OBJECT_TYPE(2000, "JAVA_OBJECT"),
    LONGVARBINARY_TYPE(-4, "LONGVARBINARY"),
    LONGVARCHAR_TYPE(-1, "LONGVARCHAR"),
    NULL_TYPE(0, "NULL"),
    NUMERIC_TYPE(2, "NUMERIC"){

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, arg, this);
            if (arg.precision != Integer.MIN_VALUE) {
                sb.append("(");
                sb.append(arg.precision);
                if (arg.scale != Integer.MIN_VALUE) {
                    sb.append(",");
                    sb.append(arg.scale);
                }
                sb.append(")");
            }
        }

        @Override
        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";");
            sb.append(Helper.NL);
        }

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";");
            sb.append(Helper.NL);
        }
    }
    ,
    OTHER_TYPE(1111, "OTHER"),
    REAL_TYPE(7, "REAL"),
    REF_TYPE(2006, "REF"),
    SMALLINT_TYPE(5, "SMALLINT"),
    STRUCT_TYPE(2002, "STRUCT"),
    TIME_TYPE(92, "TIME"),
    TIMESTAMP_TYPE(93, "TIMESTAMP"),
    TINYINT_TYPE(-6, "TINYINT"),
    VARBINARY_TYPE(-3, "VARBINARY"),
    VARCHAR_TYPE(12, "VARCHAR"){

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, arg, this);
            if (arg.length != Integer.MIN_VALUE) {
                sb.append("(");
                sb.append(arg.length);
                sb.append(")");
            }
        }

        @Override
        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";");
            sb.append(Helper.NL);
        }

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";");
            sb.append(Helper.NL);
        }
    }
    ,
    NVARCHAR_TYPE(-9, "NVARCHAR"){

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, arg, this);
            if (arg.length != Integer.MIN_VALUE) {
                sb.append("(");
                sb.append(arg.length);
                sb.append(")");
            }
        }

        @Override
        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";");
            sb.append(Helper.NL);
        }

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";");
            sb.append(Helper.NL);
        }
    }
    ,
    NVARCHAR2_TYPE(-9, "NVARCHAR2"){

        protected void buildInitialDeclare(StringBuilder sb, PLSQLargument arg) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, arg, this);
            if (arg.length != Integer.MIN_VALUE) {
                sb.append("(");
                sb.append(arg.length);
                sb.append(")");
            }
        }

        @Override
        public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
            this.buildInitialDeclare(sb, inArg);
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";");
            sb.append(Helper.NL);
        }

        @Override
        public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
            this.buildInitialDeclare(sb, outArg);
            sb.append(";");
            sb.append(Helper.NL);
        }
    };

    private final int typeCode;
    private final String typeName;

    private JDBCTypes(int typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    @Override
    public boolean isComplexDatabaseType() {
        return false;
    }

    @Override
    public boolean isJDBCType() {
        return true;
    }

    @Override
    public int getSqlCode() {
        return this.typeCode;
    }

    @Override
    public int getConversionCode() {
        return this.getSqlCode();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public int computeInIndex(PLSQLargument inArg, int newIndex, ListIterator<PLSQLargument> i) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeInIndex(inArg, newIndex);
    }

    @Override
    public int computeOutIndex(PLSQLargument outArg, int newIndex, ListIterator<PLSQLargument> i) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeOutIndex(outArg, newIndex);
    }

    @Override
    public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, inArg, this);
        sb.append(" := :");
        sb.append(inArg.inIndex);
        sb.append(";");
        sb.append(Helper.NL);
    }

    @Override
    public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(sb, outArg, this);
        sb.append(";");
        sb.append(Helper.NL);
    }

    @Override
    public void buildBeginBlock(StringBuilder sb, PLSQLargument arg, PLSQLStoredProcedureCall call) {
    }

    @Override
    public void buildOutAssignment(StringBuilder sb, PLSQLargument outArg, PLSQLStoredProcedureCall call) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutAssignment(sb, outArg, call);
    }

    @Override
    public void translate(PLSQLargument arg, AbstractRecord translationRow, AbstractRecord copyOfTranslationRow, List<DatabaseField> copyOfTranslationFields, List<DatabaseField> translationRowFields, List translationRowValues, StoredProcedureCall call) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(arg, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues, call);
    }

    @Override
    public void buildOutputRow(PLSQLargument outArg, AbstractRecord outputRow, DatabaseRecord newOutputRow, List<DatabaseField> outputRowFields, List outputRowValues) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(outArg, outputRow, newOutputRow, outputRowFields, outputRowValues);
    }

    @Override
    public void logParameter(StringBuilder sb, Integer direction, PLSQLargument arg, AbstractRecord translationRow, DatabasePlatform platform) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.logParameter(sb, direction, arg, translationRow, platform);
    }

    public static DatabaseType getDatabaseTypeForCode(int typeCode) {
        JDBCTypes databaseType = null;
        switch (typeCode) {
            case 2003: {
                databaseType = ARRAY_TYPE;
                break;
            }
            case -5: {
                databaseType = BIGINT_TYPE;
                break;
            }
            case -2: {
                databaseType = BINARY_TYPE;
                break;
            }
            case -7: {
                databaseType = BIT_TYPE;
                break;
            }
            case 2004: {
                databaseType = BLOB_TYPE;
                break;
            }
            case 16: {
                databaseType = BOOLEAN_TYPE;
                break;
            }
            case 1: {
                databaseType = CHAR_TYPE;
                break;
            }
            case 2005: {
                databaseType = CLOB_TYPE;
                break;
            }
            case 70: {
                databaseType = DATALINK_TYPE;
                break;
            }
            case 91: {
                databaseType = DATE_TYPE;
                break;
            }
            case 3: {
                databaseType = DECIMAL_TYPE;
                break;
            }
            case 2001: {
                databaseType = DISTINCT_TYPE;
                break;
            }
            case 8: {
                databaseType = DOUBLE_TYPE;
                break;
            }
            case 6: {
                databaseType = FLOAT_TYPE;
                break;
            }
            case 4: {
                databaseType = INTEGER_TYPE;
                break;
            }
            case 2000: {
                databaseType = JAVA_OBJECT_TYPE;
                break;
            }
            case -4: {
                databaseType = LONGVARBINARY_TYPE;
                break;
            }
            case -1: {
                databaseType = LONGVARCHAR_TYPE;
                break;
            }
            case -15: {
                databaseType = NCHAR_TYPE;
                break;
            }
            case 0: {
                databaseType = NULL_TYPE;
                break;
            }
            case 2: {
                databaseType = NUMERIC_TYPE;
                break;
            }
            case -9: {
                databaseType = NVARCHAR_TYPE;
                break;
            }
            case 1111: {
                databaseType = OTHER_TYPE;
                break;
            }
            case 7: {
                databaseType = REAL_TYPE;
                break;
            }
            case 2006: {
                databaseType = REF_TYPE;
                break;
            }
            case 5: {
                databaseType = SMALLINT_TYPE;
                break;
            }
            case 2002: {
                databaseType = STRUCT_TYPE;
                break;
            }
            case 92: {
                databaseType = TIME_TYPE;
                break;
            }
            case 93: {
                databaseType = TIMESTAMP_TYPE;
                break;
            }
            case -6: {
                databaseType = TINYINT_TYPE;
                break;
            }
            case -3: {
                databaseType = VARBINARY_TYPE;
                break;
            }
            case 12: {
                databaseType = VARCHAR_TYPE;
            }
        }
        return databaseType;
    }

    public static Class<?> getClassForCode(int typeCode) {
        Class clz = ClassConstants.STRING;
        switch (typeCode) {
            case 2003: {
                clz = Array.class;
                break;
            }
            case -5: 
            case 2: 
            case 3: {
                clz = ClassConstants.BIGDECIMAL;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                clz = ClassConstants.BLOB;
                break;
            }
            case 2005: {
                clz = ClassConstants.CLOB;
                break;
            }
            case 16: {
                clz = ClassConstants.BOOLEAN;
                break;
            }
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2006: {
                clz = ClassConstants.Object_Class;
                break;
            }
            case 0: {
                clz = ClassConstants.Void_Class;
                break;
            }
            case 91: {
                clz = ClassConstants.JavaSqlDate_Class;
                break;
            }
            case 93: {
                clz = ClassConstants.JavaSqlTimestamp_Class;
                break;
            }
            case 8: {
                clz = ClassConstants.DOUBLE;
                break;
            }
            case 6: 
            case 7: {
                clz = ClassConstants.FLOAT;
                break;
            }
            case 4: {
                clz = ClassConstants.INTEGER;
                break;
            }
            case -7: 
            case -6: 
            case 5: {
                clz = ClassConstants.SHORT;
                break;
            }
            case 2002: {
                clz = Struct.class;
                break;
            }
            case 92: {
                clz = ClassConstants.JavaSqlTime_Class;
            }
        }
        return clz;
    }

    /* synthetic */ JDBCTypes(String string2, int n, int n2, String string3, JDBCTypes jDBCTypes) {
        this(n2, string3);
    }
}

